package org.lsst.ccs.gconsole.plugins.tracer.filters;

import java.util.Arrays;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;

/**
 * Adapter to simplify implementing parameterized {@link MessageFilter}.
 *
 * @author onoprien
 */
abstract public class AbstractMessageFilter implements MessageFilter {

// -- Fields : -----------------------------------------------------------------
    
    private String[] par;

// -- Life cycle : -------------------------------------------------------------
    
    
// -- Getters/setters : --------------------------------------------------------

    @Override
    public String[] getParameters() {
        return par == null ? new String[0] : Arrays.copyOf(par, par.length);
    }

    @Override
    public void setParameters(String[] parameters) {
        par = parameters == null || parameters.length == 0 ? null : Arrays.copyOf(parameters, parameters.length);
    }

}
