package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;

/**
 * Traditional monitoring GUI panel (implements {@code MonitorGui.Panel}).
 * Used by {@link TradStylePlugin}.
 */
public class TradMonitorAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    TradMonitorPanel panel;
    
    public TradMonitorAssembly(TradMonitorGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
        panel = new TradMonitorPanel(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystem(String raftName) {
        mon.setSubsystems(raftName);
        panel.setSubsystem(raftName);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem(id);
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof MonitorFullState) {
            MonitorFullState r = (MonitorFullState)d;
            mon.updateTableModel(name, r);
            panel.updateControlPanel(id, r.getMonitorState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key,
                                 Object d) {
        if (key.equals(MonitorState.KEY)) {
            panel.updateControlPanel(id, (MonitorState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
