package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.io.Serializable;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;

/**
 * Associate a path and a name to a dictionary.
 * @author LSST CCS Team
 */
class ComponentDictionary implements Serializable {
    private static final long serialVersionUID = -4397011115721128717L;

    final String path;
    final String name;
    final Dictionary dictionary;
    final CommandSet commandSet;
    
    ComponentDictionary(String path, String name, Dictionary dictionary, CommandSet commandSet) {
        this.path = path;
        this.name = name;
        this.dictionary = dictionary;
        this.commandSet = commandSet;
    }
    
    @Override
    public String toString() {
        return name;
    }
    
}
