package org.lsst.ccs.subsystem.monitor.ui.tree;

/**
 * Enumeration of data fields associated with each monitoring channel.
 *
 * @author onoprien
 */
public enum Field {
    
    NAME(false, false, "Name"),
    VALUE(true, false, "Value"), 
    UNITS(false, false, "Units"), 
    LOW(true, true, "Low Limit"), 
    ALERT_LOW(false, false, "Al."), 
    HIGH(true, true, "High Limit"), 
    ALERT_HIGH(false, false, "Al."), 
    DESCR(false, false, "Description");
    
    private final boolean updatable;
    private final boolean editable;
    private final String humanReadable;
    
    Field(boolean updatable, boolean editable, String humanReadable) {
        this.updatable = updatable;
        this.editable = editable;
        this.humanReadable = humanReadable;
    }
    
    public boolean isUpdatable() {return updatable;}
    
    public boolean isEditable() {return editable;}

    @Override
    public String toString() {
        return humanReadable;
    }

}
