package org.lsst.ccs.gconsole.util.session;

import java.io.Serializable;

/**
 * Interface to be implemented by components whose state can be saved and restored as a part of the graphical console session.
 *
 * @author onoprien
 */
public interface Savable {
    
    default void restore(Serializable descriptor) {
    }
    
    default Serializable save() {
        return null;
    }
    
}
