package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;

/**
 * 
 *
 * @author onoprien
 */
public class CellView extends JLabel implements MonitorView, AgentChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final String path;
    private AgentChannel channel;
    private int maxLength;
    private Dimension size, maxSize;
    

// -- Life cycle : -------------------------------------------------------------
    
    public CellView(String content) {
        path = content;
        setOpaque(true);
        setBorder(BorderFactory.createLineBorder(Color.BLACK));
        maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        setText("<html>12345<br>67890");
        setHorizontalAlignment(CENTER);
        setVerticalAlignment(CENTER);
    }
    
    public void setMaxLength(int length) {
        maxLength = length;
    }
    
// -- Implementing MonitorView : -----------------------------------------------

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return this;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
    }

    @Override
    public Descriptor save() {
        return MonitorView.super.save();
    }

    @Override
    public void restore(Descriptor descriptor) {
        MonitorView.super.restore(descriptor);
    }
    
    
// -- Implementing AgentStatusListener : ---------------------------------------

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> {
            update(event);
        });
    }

    @Override
    public void configure(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> {
            update(event);
        });
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> {
            channel = null;
            format();
        });
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> {
            update(event);
        });
    }
    
    private void update(AgentStatusEvent event) {
        if (channel == null) {
            List<AgentChannel> cc = event.getAddedChannels();
            if (!cc.isEmpty()) {
                channel = cc.get(0);
                format();
            }
        } else {
            if (!event.getRemovedChannels().isEmpty()) {
                channel = null;
                format();
            } else if (!event.getStatusChanges().isEmpty()) {
                format();
            }
        }
    }
    
    private void format() {
        FormattedValue fv = MonitorFormat.DEFAULT.format(MonitorField.VALUE, channel);
        setBackground(fv.getBgColor());
        setForeground(fv.getFgColor());
        setHorizontalAlignment(fv.getHorizontalAlignment());
        setToolTipText(fv.getToolTip());
    }
    
    
// -- Implementing Filter : ----------------------------------------------------
    
    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList(path);
    }

    @Override
    public List<String> getDisplayChannels() {
        return Collections.singletonList(path);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        return Collections.singletonList(path);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return Collections.singletonList(AgentChannel.Key.VALUE);
    }
    
    
// -- Overriding JLabel : ------------------------------------------------------

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return maxSize;
    }    
    
}
