/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.base.InstanceDialog;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilterFactory;
import org.lsst.ccs.gconsole.plugins.tracer.TracerFilter;
import org.lsst.ccs.gconsole.plugins.tracer.UserFilter;
import org.lsst.ccs.gconsole.plugins.tracer.filters.AlertSelector;
import org.lsst.ccs.gconsole.plugins.tracer.filters.HeartBeatSelector;
import org.lsst.ccs.gconsole.plugins.tracer.filters.LegacyFormatter;
import org.lsst.ccs.gconsole.plugins.tracer.filters.StandardMessageFilter;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;

public class FilterRegistry {
    static final String USER = "User/";
    private final LsstTracerPlugin plugin;
    private final Map<String, MessageFilterFactory> filters = new ConcurrentHashMap<String, MessageFilterFactory>(4, 0.75f, 1);
    private Lookup.Result result1;
    private final List<String> builtinFilterClasses = Arrays.asList("org.lsst.ccs.gconsole.plugins.tracer.filters.StandardMessageFilter");

    FilterRegistry(LsstTracerPlugin plugin) {
        this.plugin = plugin;
    }

    void init() {
        this.addFactory(new LegacyFormatter());
        this.addFactory(new HeartBeatSelector());
        this.addFactory(new AlertSelector());
        this.addFactory(new StandardMessageFilter.Default());
        this.addFactory(new StandardMessageFilter.All());
        FreeHEPLookup lookup = this.plugin.getConsole().getConsoleLookup();
        LookupListener listener = e -> this.updateLocalFilters();
        Lookup.Template template = new Lookup.Template(MessageFilterFactory.class);
        this.result1 = lookup.lookup(template);
        this.result1.addLookupListener(listener);
        this.updateLocalFilters();
        this.addUserFilters(this.getUserFiltersFile());
    }

    public MessageFilter getFilter(String name) {
        MessageFilterFactory factory = this.filters.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("Unrecognized filter: " + name);
        }
        try {
            MessageFilter filter = factory.get(null);
            if (filter == null) {
                throw new IllegalArgumentException("Unable to retrieve filter: " + name);
            }
            return filter;
        }
        catch (Exception x) {
            throw new IllegalArgumentException("Unable to retrieve filter: " + name, x);
        }
    }

    public void saveFilter(UserFilter filter) throws IOException {
        try {
            Element filtersElement;
            Element filterElement;
            Document document;
            File inputFile = this.getUserFiltersFile();
            SAXReader reader = new SAXReader();
            try {
                document = reader.read(inputFile);
            }
            catch (DocumentException x) {
                document = DocumentHelper.createDocument();
                document.addElement("filters");
            }
            String name = filter.getPath();
            if (name.startsWith(USER)) {
                name = name.substring(USER.length(), name.length());
            }
            if ((filterElement = (Element)(filtersElement = (Element)document.selectSingleNode("/filters")).selectSingleNode("filter[@name='" + name + "']")) != null) {
                filtersElement.remove(filterElement);
            }
            filterElement = filtersElement.addElement("filter");
            filterElement.addAttribute("name", name);
            String description = filter.getDescription();
            if (description != null) {
                filterElement.addElement("description").addText(description);
            }
            Element stepsElement = filterElement.addElement("steps");
            int nSteps = filter.filters.length;
            for (int step = 0; step < nSteps; ++step) {
                FilteredMessage.Flag action;
                TracerFilter tf = filter.filters[step];
                Element stepElement = stepsElement.addElement("step");
                if (filter.or[step]) {
                    stepElement.addElement("or");
                }
                stepElement.addElement("mode").addText(tf.getMode().name());
                if (tf.isInverted()) {
                    stepElement.addElement("invert");
                }
                if (tf.isFormatting()) {
                    stepElement.addElement("format");
                }
                stepElement.addElement("target").addText(tf.getTarget().name());
                stepElement.addElement("method").addText(tf.getMethod().name());
                stepElement.addElement("code").addText(tf.getCode());
                Color color = tf.getColor();
                if (color != null) {
                    stepElement.addElement("color").addText(FilterRegistry.encode(color));
                }
                if ((action = tf.getAction()) == null) continue;
                stepElement.addElement("action").addText(action.name());
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            if (!inputFile.exists()) {
                inputFile.getParentFile().mkdirs();
            }
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(inputFile), format);
            writer.write(document);
            this.addFactory(new UserFilterFactory(name, description));
        }
        catch (IOException | ClassCastException | IllegalArgumentException | IndexOutOfBoundsException | NullPointerException x) {
            throw new IOException("Unable to save filter " + filter.getPath(), x);
        }
    }

    public void deleteFilter(String name) throws IOException {
        if (!name.startsWith(USER)) {
            return;
        }
        this.filters.remove(name);
        name = name.substring(USER.length(), name.length());
        try {
            File inputFile = this.getUserFiltersFile();
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputFile);
            Element filtersElement = (Element)document.selectSingleNode("/filters");
            Element filterElement = (Element)filtersElement.selectSingleNode("filter[@name='" + name + "']");
            if (filterElement != null) {
                filtersElement.remove(filterElement);
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(inputFile), format);
                writer.write(document);
            }
        }
        catch (IOException | ClassCastException | IllegalArgumentException | NullPointerException | DocumentException x) {
            throw new IOException("Unable to delete filter User/" + name, x);
        }
    }

    public MessageFilter selectFilter(Component parent) {
        ArrayList<Object> factories = new ArrayList<Object>(this.filters.size() + this.builtinFilterClasses.size());
        factories.addAll(this.filters.values());
        factories.addAll(this.builtinFilterClasses);
        InstanceDialog d = InstanceDialog.show(MessageFilter.class, parent, "Select message filter", factories);
        MessageFilter filter = (MessageFilter)d.getInstance();
        if (filter != null) {
            filter.setParameters(d.getDescriptor().getParameters());
        }
        return filter;
    }

    public String selectFilterCode(Component parent) {
        MessageFilter filter = this.selectFilter(parent);
        if (filter == null) {
            return null;
        }
        InstanceDialog.Descriptor descriptor = new InstanceDialog.Descriptor(filter.getPath(), filter.getParameters());
        return descriptor.toString();
    }

    public MessageFilter createFilter(String path, String[] parameters) {
        if (path == null) {
            return null;
        }
        MessageFilterFactory factory = this.filters.get(path);
        if (factory == null) {
            InstanceDialog.Descriptor descriptor = new InstanceDialog.Descriptor();
            descriptor.setPath(path);
            descriptor.setParameters(parameters);
            ArrayList<Object> factories = new ArrayList<Object>(this.filters.size() + this.builtinFilterClasses.size());
            factories.addAll(this.filters.values());
            factories.addAll(this.builtinFilterClasses);
            MessageFilter filter = InstanceDialog.getInstance(descriptor, MessageFilter.class, factories);
            if (filter != null) {
                filter.setParameters(parameters);
            }
            return filter;
        }
        return factory.get(parameters);
    }

    public MessageFilter createFilter(InstanceDialog.Descriptor descriptor) {
        String path = descriptor.getPath();
        if (path == null) {
            return null;
        }
        MessageFilterFactory factory = this.filters.get(path);
        if (factory == null) {
            ArrayList<Object> factories = new ArrayList<Object>(this.filters.size() + this.builtinFilterClasses.size());
            factories.addAll(this.filters.values());
            factories.addAll(this.builtinFilterClasses);
            MessageFilter filter = InstanceDialog.getInstance(descriptor, MessageFilter.class, factories);
            if (filter != null) {
                filter.setParameters(descriptor.getParameters());
            }
            return filter;
        }
        return factory.get(descriptor.getParameters());
    }

    public MessageFilter createFilter(String code) {
        return this.createFilter(new InstanceDialog.Descriptor(code));
    }

    void addFactory(MessageFilterFactory factory) {
        this.filters.put(factory.getPath(), factory);
    }

    private UserFilter openFilter(String shortName) {
        try {
            File inputFile = this.getUserFiltersFile();
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputFile);
            Node filterNode = document.selectSingleNode("/filters/filter[@name='" + shortName + "']");
            List stepNodes = filterNode.selectNodes("steps/step");
            int nSteps = stepNodes.size();
            TracerFilter[] steps = new TracerFilter[nSteps];
            boolean[] ors = new boolean[nSteps];
            for (int step = 0; step < nSteps; ++step) {
                Node stepNode = (Node)stepNodes.get(step);
                ors[step] = stepNode.selectSingleNode("or") != null;
                String s = stepNode.selectSingleNode("mode").getText().trim();
                TracerFilter.Mode mode = TracerFilter.Mode.valueOf(s);
                boolean invert = stepNode.selectSingleNode("invert") != null;
                boolean format = stepNode.selectSingleNode("format") != null;
                s = stepNode.selectSingleNode("target").getText().trim();
                TracerFilter.Target target = TracerFilter.Target.valueOf(s);
                s = stepNode.selectSingleNode("method").getText().trim();
                TracerFilter.Method method = TracerFilter.Method.valueOf(s);
                String code = stepNode.selectSingleNode("code").getText();
                Node node = stepNode.selectSingleNode("color");
                Color color = null;
                if (node != null && !(s = node.getText().trim()).isEmpty()) {
                    color = Color.decode("#" + s);
                }
                node = stepNode.selectSingleNode("action");
                FilteredMessage.Flag action = null;
                if (node != null && !(s = node.getText().trim()).isEmpty()) {
                    action = FilteredMessage.Flag.valueOf(s);
                }
                steps[step] = new TracerFilter(mode, invert, format, target, method, code, color, action, this);
            }
            return new UserFilter(USER + shortName, steps, ors);
        }
        catch (ClassCastException | IllegalArgumentException | IndexOutOfBoundsException | NullPointerException | DocumentException x) {
            throw new IllegalArgumentException("Unable to read filter " + shortName + " from storage", x);
        }
    }

    private void updateLocalFilters() {
        this.filters.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("LOCAL"));
        Collection c = this.result1.allInstances();
        c.forEach(o -> this.addFactory((MessageFilterFactory)o));
    }

    private File getUserFiltersFile() {
        Path consoleHome = this.plugin.getConsole().getHomeDirectory();
        if (consoleHome == null) {
            return null;
        }
        return consoleHome.resolve("tracer/filters.xml").toFile();
    }

    private void addUserFilters(File file) {
        if (file == null) {
            return;
        }
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(file);
            List nodes = document.selectNodes("/filters/filter");
            nodes.forEach(node -> {
                String name = node.valueOf("@name");
                Node descNode = node.selectSingleNode("description");
                String description = descNode == null ? null : descNode.getText().trim();
                this.addFactory(new UserFilterFactory(name, description));
            });
        }
        catch (NullPointerException | DocumentException throwable) {
            // empty catch block
        }
    }

    static final String encode(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    private class UserFilterFactory
    implements MessageFilterFactory {
        private final String name;
        private final String desc;

        private UserFilterFactory(String shortName, String description) {
            this.name = shortName;
            this.desc = description;
        }

        @Override
        public String getPath() {
            return FilterRegistry.USER + this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public MessageFilter get(String[] parameters) {
            return FilterRegistry.this.openFilter(this.name);
        }

        public MessageFilter getInstance() {
            return FilterRegistry.this.openFilter(this.name);
        }
    }
}

