package org.lsst.ccs.gconsole.util;

import java.util.*;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

/**
 * 
 *
 * @author onoprien
 */
public class TreeUtil {

// -- Saving expansion state : -------------------------------------------------
    
    static public ArrayList<TreePath> saveExpansionState(JTree tree) {
        ArrayList<TreePath> expanded = new  ArrayList<>();
        int nRows = tree.getRowCount();
//        TreePath prev = tree.isRootVisible() ? null : new TreePath(tree.getModel().getRoot());
        TreePath prev = null;
        for (int row=0; row < nRows; row++) {
            TreePath curr = tree.getPathForRow(row);
            if (prev != null && !prev.isDescendant(curr)) {
                expanded.add(prev);
                prev = null;
            }
            if (tree.isExpanded(row)) {
                prev = curr;
            }
        }
        if (prev != null) expanded.add(prev);
//        System.out.println("\nSaved:");
//        expanded.forEach(path -> System.out.println(path));
        return expanded;
//        return new ExpansionState(expanded);
    }
    
    static public void restoreExpansionState(JTree tree, ArrayList<TreePath> state) {
        state.forEach(path -> {
            tree.expandPath(path);
        });
    }
    
//    static private boolean isDescendant(TreePath parent, TreePath path) {
//        int parentLength = parent.getPathCount();
//        int pathLength = path.getPathCount();
//        if (parentLength <= pathLength) return false;
//        while (parentLength > pathLength){
//            parent = parent.getParentPath();
//            parentLength--;
//        }
//        return parent.equals(path);
//    }
    
//    static public class ExpansionState {
//        
//        private ExpansionState(ArrayList<TreePath> expandedPaths) {
//            
//        }
//        
//    }

}
