/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.lsst.ccs.Agent;
import org.lsst.ccs.AgentPropertyPredicate;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class AgentStatusAggregatorService
implements StatusMessageListener,
ServiceLifecycle,
AgentPresenceListener {
    private Map<String, Map<String, StatusAggregateConfig>> config = new ConcurrentHashMap<String, Map<String, StatusAggregateConfig>>();
    @ConfigurationParameter(isFinal=true)
    private List<StatusAggregateConfig> patternConfigList = new CopyOnWriteArrayList<StatusAggregateConfig>();
    private final List<StatusAggregateConfig> internalConfig = new CopyOnWriteArrayList<StatusAggregateConfig>();
    private Map<String, ConcurrentLinkedQueue<TimedValue>> history = new ConcurrentHashMap<String, ConcurrentLinkedQueue<TimedValue>>();
    private Map<String, TimedValue> last = new ConcurrentHashMap<String, TimedValue>();
    private Map<String, TimedValueStats> stats = new ConcurrentHashMap<String, TimedValueStats>();
    private final Map<String, String> aliasToSourceBasedMap = new ConcurrentHashMap<String, String>();
    private static final StatusAggregateConfig DUMMY_CONFIG = new StatusAggregateConfig();
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.status.aggregator");
    private final Agent agent;
    private final Predicate<BusMessage<?, ?>> allStatusSubsystemDataFilter = BusMessageFilterFactory.messageClass(StatusSubsystemData.class);
    private AggregatorAgentPropertiesMessagePredicate busMessageFilter;
    private boolean canAddAggregatorConfiguration = true;

    public AgentStatusAggregatorService(Agent a) {
        this.agent = a;
        ComponentNode agentStatusAggregatorServiceComponentNode = new ComponentNode(this.agent.getComponentLookup().getTopComponentNode(), "agentStatusAggregatorService", (Object)this);
        this.agent.getComponentLookup().addComponentNodeToLookup(this.agent.getComponentLookup().getTopComponentNode(), agentStatusAggregatorServiceComponentNode);
    }

    @Override
    public void preStart() {
        this.canAddAggregatorConfiguration = false;
        this.internalConfig.addAll(this.patternConfigList);
        if (this.internalConfig.size() > 0) {
            this.log.info((Object)("About to start Aggregator Service with " + this.internalConfig.size() + " patterns"));
            for (StatusAggregateConfig cfg : this.internalConfig) {
                this.log.info((Object)(cfg + " " + cfg.alias));
            }
            this.busMessageFilter = new AggregatorAgentPropertiesMessagePredicate(this.internalConfig);
            this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
            this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, this.busMessageFilter.and(this.allStatusSubsystemDataFilter));
        }
    }

    public void disconnecting(AgentInfo agent) {
        this.config.remove(agent.getName());
        if (this.busMessageFilter != null) {
            this.busMessageFilter.disconnectingAgent(agent);
        }
    }

    @ConfigurationParameterChanger(propertyName="patternConfigList")
    protected void setPatternConfigList(List<StatusAggregateConfig> list) {
        this.log.info((Object)("Configuring status aggregator with " + list));
        if (!this.canAddAggregatorConfiguration || this.patternConfigList.size() > 0) {
            throw new IllegalStateException("Wrong time to add configurations: either it's too late if canAddConfiguration is false (" + this.canAddAggregatorConfiguration + ") or the list is not empty (size = " + this.patternConfigList.size() + ")");
        }
        this.patternConfigList.addAll(list);
    }

    public List<StatusAggregateConfig> getStatusAggregateConfig() {
        return this.internalConfig;
    }

    public void setAggregatePattern(AgentPropertyPredicate agentPropertyPredicate, String pattern) {
        this.setAggregatePattern(agentPropertyPredicate, pattern, -1, -1, "");
    }

    public void setAggregatePattern(AgentPropertyPredicate agentPropertyPredicate, String pattern, String alias) {
        this.setAggregatePattern(agentPropertyPredicate, pattern, -1, -1, alias);
    }

    public void setAggregatePattern(AgentPropertyPredicate agentPropertyPredicate, String pattern, int historyDuration, int aggregateWindow, String alias) {
        this.setAggregatePattern(agentPropertyPredicate, Pattern.compile(pattern), historyDuration, aggregateWindow, alias);
    }

    protected void setAggregatePattern(AgentPropertyPredicate agentPropertyPredicate, Pattern pattern, int historyDuration, int aggregateWindow, String alias) {
        StatusAggregateConfig c = new StatusAggregateConfig(agentPropertyPredicate, pattern, historyDuration, aggregateWindow, alias);
        if (!this.canAddAggregatorConfiguration) {
            throw new IllegalStateException("Wrong time to add configurations. Should be added before the pre-start phase");
        }
        this.internalConfig.add(c);
    }

    protected StatusAggregateConfig getConfig(AgentInfo agent, String dataKey, String sourceBasedFullKey) {
        Map<String, StatusAggregateConfig> mapForAgent;
        StatusAggregateConfig c;
        if (!this.config.containsKey(agent.getName())) {
            this.config.put(agent.getName(), new ConcurrentHashMap());
        }
        if ((c = (mapForAgent = this.config.get(agent.getName())).get(sourceBasedFullKey)) != null) {
            return c == DUMMY_CONFIG ? null : c;
        }
        for (StatusAggregateConfig cfg : this.internalConfig) {
            c = cfg;
            if (!c.agentPropertyPredicate.test(agent) || !c.pattern.matcher(dataKey).matches()) continue;
            mapForAgent.put(sourceBasedFullKey, c);
            this.aliasToSourceBasedMap.put(this.getFullPathForData(dataKey, c, agent), sourceBasedFullKey);
            return c;
        }
        mapForAgent.put(sourceBasedFullKey, DUMMY_CONFIG);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStatusMessage(StatusMessage msg) {
        Object encodedData = msg.getEncodedData();
        if (encodedData instanceof KeyValueDataList) {
            KeyValueDataList list = (KeyValueDataList)encodedData;
            String source = msg.getOriginAgentInfo().getName();
            for (KeyValueData data : list.getListOfKeyValueData()) {
                ConcurrentLinkedQueue q;
                int kept;
                String key = data.getKey();
                Serializable value = data.getValue();
                String sourceBasedFullKey = source + '/' + key;
                StatusAggregateConfig c = this.getConfig(msg.getOriginAgentInfo(), key, sourceBasedFullKey);
                if (c == null) continue;
                String dataBasedFullKey = this.getFullPathForData(key, c, msg.getOriginAgentInfo());
                this.last.put(dataBasedFullKey, new TimedValue(dataBasedFullKey, data.getCCSTimeStamp(), value));
                int n = kept = c.historyDuration > c.aggregateWindow ? c.historyDuration : c.aggregateWindow;
                if (kept < 0) continue;
                long timeStamp = data.getCCSTimeStamp().getUTCInstant().toEpochMilli();
                long aggregateBound = c.aggregateWindow < 0 ? Long.MAX_VALUE : timeStamp - (long)c.aggregateWindow;
                long stopBound = timeStamp - (long)kept;
                ConcurrentLinkedQueue concurrentLinkedQueue = q = this.history.computeIfAbsent(dataBasedFullKey, key_name -> new ConcurrentLinkedQueue());
                synchronized (concurrentLinkedQueue) {
                    TimedValue v;
                    q.add(new TimedValue(dataBasedFullKey, data.getCCSTimeStamp(), value));
                    if (c.aggregateWindow > 0) {
                        TimedValueStats st = this.stats.computeIfAbsent(dataBasedFullKey, key_name -> new TimedValueStats());
                        if (value instanceof Number) {
                            st.add(((Number)value).doubleValue());
                        }
                        if (aggregateBound > st.firstSample) {
                            long firstRemaining = Long.MAX_VALUE;
                            for (TimedValue v2 : q) {
                                if (v2.gettStamp() < aggregateBound && v2.gettStamp() >= st.firstSample && v2.value instanceof Number) {
                                    st.remove(((Number)v2.value).doubleValue(), q, aggregateBound);
                                    continue;
                                }
                                if (v2.gettStamp() >= firstRemaining || v2.gettStamp() < aggregateBound) continue;
                                firstRemaining = v2.gettStamp();
                            }
                            st.firstSample = firstRemaining;
                        }
                    }
                    while ((v = (TimedValue)q.peek()) != null && v.gettStamp() < stopBound) {
                        q.poll();
                    }
                }
            }
        }
    }

    private String getFullPathForData(String dataKey, StatusAggregateConfig c, AgentInfo agentInfo) {
        return (c.alias.isEmpty() ? agentInfo.getName() : c.alias) + "/" + dataKey;
    }

    public Object getLast(String key) {
        TimedValue v = this.last.get(key);
        return v == null ? null : v.value;
    }

    public TimedValue getLastTV(String key) {
        return this.last.get(key);
    }

    public double getAverage(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return Double.NaN;
        }
        return st.average();
    }

    public double getStdDev(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return Double.NaN;
        }
        return st.stddev();
    }

    public double getMin(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return Double.NaN;
        }
        return st.min;
    }

    public double getMax(String key) {
        TimedValueStats st = this.stats.get(key);
        if (st == null) {
            throw new NoSuchElementException();
        }
        if (st.n == 0) {
            return Double.NaN;
        }
        return st.max;
    }

    public List<TimedValue> getHistory(String key) {
        ConcurrentLinkedQueue<TimedValue> hh = this.history.get(key);
        if (hh == null) {
            return null;
        }
        ArrayList<TimedValue> l = new ArrayList<TimedValue>();
        String sourceBasedFullPath = this.aliasToSourceBasedMap.get(key);
        StatusAggregateConfig cf = null;
        for (Map<String, StatusAggregateConfig> m : this.config.values()) {
            if (!m.containsKey(sourceBasedFullPath)) continue;
            cf = m.get(sourceBasedFullPath);
            break;
        }
        if (cf != null) {
            long lastSample = this.last.get(key).gettStamp();
            long firstSample = lastSample - (long)cf.historyDuration;
            for (TimedValue tv : hh) {
                if (tv.gettStamp() < firstSample) continue;
                l.add(tv);
            }
        }
        return l.isEmpty() ? null : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getStatistics(String key) {
        Statistics s;
        ConcurrentLinkedQueue<TimedValue> q;
        ConcurrentLinkedQueue<TimedValue> concurrentLinkedQueue = q = this.history.get(key);
        synchronized (concurrentLinkedQueue) {
            s = new Statistics(this.getMin(key), this.getMax(key), this.getAverage(key), this.getStdDev(key));
        }
        return s;
    }

    public Map<String, Object> getAllLast() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String k : this.last.keySet()) {
            m.put(k, this.getLast(k));
        }
        return m;
    }

    public Map<String, TimedValue> getAllLastTV() {
        HashMap<String, TimedValue> m = new HashMap<String, TimedValue>();
        for (String k : this.last.keySet()) {
            m.put(k, this.getLastTV(k));
        }
        return m;
    }

    public Map<String, Statistics> getAllStatistics() {
        HashMap<String, Statistics> m = new HashMap<String, Statistics>();
        for (String k : this.stats.keySet()) {
            m.put(k, this.getStatistics(k));
        }
        return m;
    }

    private static class AggregatorAgentPropertiesMessagePredicate
    implements Predicate<BusMessage<?, ?>> {
        private final List<AgentPropertyPredicate> agentPropertyPredicateList = new CopyOnWriteArrayList<AgentPropertyPredicate>();
        private final Map<String, Boolean> acceptanceMap = new ConcurrentHashMap<String, Boolean>();

        AggregatorAgentPropertiesMessagePredicate(List<StatusAggregateConfig> configs) {
            for (StatusAggregateConfig cfg : configs) {
                this.agentPropertyPredicateList.add(cfg.agentPropertyPredicate);
            }
        }

        void disconnectingAgent(AgentInfo a) {
            this.acceptanceMap.remove(a.getName());
        }

        @Override
        public boolean test(BusMessage t) {
            AgentInfo agentInfo = t.getOriginAgentInfo();
            if (this.acceptanceMap.containsKey(agentInfo.getName())) {
                return this.acceptanceMap.get(agentInfo.getName());
            }
            for (AgentPropertyPredicate predicate : this.agentPropertyPredicateList) {
                if (!predicate.test(agentInfo)) continue;
                this.acceptanceMap.put(agentInfo.getName(), Boolean.TRUE);
                return true;
            }
            this.acceptanceMap.put(agentInfo.getName(), Boolean.FALSE);
            return false;
        }
    }

    private static class TimedValueStats {
        public String name;
        public int n = 0;
        public double sum = 0.0;
        public double sum2 = 0.0;
        public double min = Double.MAX_VALUE;
        public double max = Double.MIN_NORMAL;
        public long firstSample;

        private TimedValueStats() {
        }

        public double average() {
            return this.n > 0 ? this.sum / (double)this.n : 0.0;
        }

        public double stddev() {
            if (this.n == 0) {
                return 0.0;
            }
            return Math.sqrt(this.sum2 / (double)this.n - this.sum * this.sum / (double)(this.n * this.n));
        }

        public void add(double value) {
            this.sum += value;
            this.sum2 += value * value;
            ++this.n;
            this.updateMinMaxIn(value);
        }

        public void remove(double value, ConcurrentLinkedQueue<TimedValue> h, long bound) {
            this.sum -= value;
            this.sum2 -= value * value;
            --this.n;
            this.updateMinMaxOut(value, h, bound);
        }

        private void updateMinMaxIn(double newValue) {
            if (newValue < this.min) {
                this.min = newValue;
            }
            if (newValue > this.max) {
                this.max = newValue;
            }
        }

        private void updateMinMaxOut(double removedValue, ConcurrentLinkedQueue<TimedValue> h, long bound) {
            if (removedValue <= this.min || removedValue >= this.max) {
                this.min = Double.MAX_VALUE;
                this.max = Double.MIN_NORMAL;
                for (TimedValue v : h) {
                    if (v.gettStamp() < bound || !(v.value instanceof Number)) continue;
                    double x = ((Number)v.value).doubleValue();
                    if (x > this.max) {
                        this.max = x;
                    }
                    if (!(x < this.min)) continue;
                    this.min = x;
                }
            }
        }
    }

    public static class TimedValue {
        private String name;
        private CCSTimeStamp tStamp;
        private Object value;

        public TimedValue(String name, CCSTimeStamp tStamp, Object value) {
            this.name = name;
            this.tStamp = tStamp;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public long gettStamp() {
            return this.tStamp.getUTCInstant().toEpochMilli();
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class StatusAggregateConfig {
        private final Map<String, String> fields;
        private static final String PREDICATE = "predicate";
        private static final String PATTERN = "pattern";
        private static final String HISTORY = "history";
        private static final String AGGREGATE = "aggregate";
        private static final String ALIAS = "alias";
        private final Pattern pattern;
        private final int historyDuration;
        private final int aggregateWindow;
        private final AgentPropertyPredicate agentPropertyPredicate;
        private final String alias;

        protected StatusAggregateConfig() {
            this.pattern = null;
            this.agentPropertyPredicate = null;
            this.historyDuration = -1;
            this.aggregateWindow = -1;
            this.fields = new HashMap<String, String>();
            this.alias = "";
        }

        public StatusAggregateConfig(AgentPropertyPredicate agentPropertyPredicate, Pattern pattern, int historyDuration, int aggregateWindow, String alias) {
            this.fields = new HashMap<String, String>();
            this.pattern = pattern;
            this.fields.put(PATTERN, pattern.pattern());
            this.agentPropertyPredicate = agentPropertyPredicate;
            this.fields.put(PREDICATE, TypeUtils.stringify((Object)agentPropertyPredicate));
            this.historyDuration = historyDuration;
            if (historyDuration >= 0) {
                this.fields.put(HISTORY, String.valueOf(historyDuration));
            }
            this.aggregateWindow = aggregateWindow;
            if (aggregateWindow >= 0) {
                this.fields.put(AGGREGATE, String.valueOf(aggregateWindow));
            }
            String string = this.alias = alias == null ? "" : alias;
            if (!this.alias.isEmpty()) {
                this.fields.put(ALIAS, this.alias);
            }
        }

        public StatusAggregateConfig(String configStr) {
            this.fields = (Map)InputConversionEngine.convertArgToType((String)configStr, Map.class);
            this.pattern = Pattern.compile(this.fields.get(PATTERN));
            this.agentPropertyPredicate = new AgentPropertyPredicate(this.fields.get(PREDICATE));
            this.historyDuration = Integer.parseInt(this.fields.getOrDefault(HISTORY, "-1"));
            this.aggregateWindow = Integer.parseInt(this.fields.getOrDefault(AGGREGATE, "-1"));
            this.alias = this.fields.getOrDefault(ALIAS, "");
        }

        public String toString() {
            return TypeUtils.stringify(this.fields);
        }
    }

    public static class Statistics {
        private double min;
        private double max;
        private double average;
        private double stddev;

        public Statistics(double min, double max, double average, double stddev) {
            this.min = min;
            this.max = max;
            this.average = average;
            this.stddev = stddev;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getAverage() {
            return this.average;
        }

        public double getStddev() {
            return this.stddev;
        }
    }
}

