package org.lsst.ccs.gconsole.jas3;

import java.util.Map;
import org.freehep.application.Application;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginFactory;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;

/**
 * Factory that instantiates graphical console plugins using {@code org.freehep.application.studio.Plugin} as a handler.
 *
 * @author onoprien
 */
public class LsstPluginFactory implements PluginFactory {
    
    static private final Jas3Console agent = (Jas3Console) Console.getConsole();
    static private final Map<String,ComponentDescriptor> config;
    
    static {
        agent.startAgent();
        config = agent.readDescriptors(null);
//        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
//            try {
//                agent.shutdownAgent();
//            } catch (Exception x) {}
//        }));
        ((Studio)Application.getApplication()).getLookup().add(agent);
    }

    @Override
    public Plugin getInstance(Studio studio, PluginInfo pluginDescriptor, ClassLoader loader) throws Throwable {
        Class pluginClass = loader.loadClass(pluginDescriptor.getMainClass());
        if (Plugin.class.isAssignableFrom(pluginClass)) {
            return (Plugin) pluginClass.newInstance();
        } else {
            ConsolePlugin consolePlugin = (ConsolePlugin) pluginClass.newInstance();
            JasPlugin jasPlugin = new JasPlugin(consolePlugin);
            Jas3PluginServices provider = new Jas3PluginServices(agent, consolePlugin, createDescriptor(pluginDescriptor), jasPlugin);
            synchronized (provider) {
                provider.start();
                consolePlugin.setServicesProvider(provider);
            }
            return jasPlugin;
        }
    }
    
    private ComponentDescriptor createDescriptor(PluginInfo pluginDescriptor) {
        ComponentDescriptor descriptor = new ComponentDescriptor();
        String name = pluginDescriptor.getName();
        descriptor.setName(name);
        descriptor.setVersion(pluginDescriptor.getVersion());
        descriptor.setDescription(pluginDescriptor.getDescription());
        ComponentDescriptor configuration = config.remove(name);
        descriptor.setConfiguration(configuration);
        return descriptor;
    }
    
    static private class JasPlugin extends Plugin {
        
        private final ConsolePlugin plugin;
        
        JasPlugin(ConsolePlugin consolePlugin) {
            plugin = consolePlugin;
        }

        @Override
        synchronized protected void init() throws Throwable {
        }

        @Override
        synchronized protected void postInit() {
            plugin.initialize();
            agent.getConsoleLookup().add(plugin);
        }

        @Override
        synchronized protected void applicationVisible() {
            plugin.start();
        }

        @Override
        synchronized protected void shutdown() {
            plugin.stop();
            plugin.shutdown();
        }
        
    }

}
