package org.lsst.ccs.gconsole.base;

import java.awt.Dimension;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

/**
 * Constants used by graphic components.
 *
 * @author onoprien
 */
public class Const {
    
    static public final int HSPACE = 10;
    static public final int VSPACE = 5;
    static public final Dimension HDIM = new Dimension(HSPACE, 0);
    static public final Dimension VDIM = new Dimension(0, VSPACE);
    
    static public final DateTimeFormatter DEFAULT_DT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());

}
