/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.taitime.TimeStorage;

class TAITime {
    private static final Logger logger = Logger.getLogger(TAITime.class.getName());
    private static boolean libFound = true;
    private static UnsatisfiedLinkError loadException;
    private final long leapSeconds;
    private final boolean leapSecondsAreReasonable;
    private static final boolean strict;
    private static final String libName;
    private static final int minLeapSeconds;

    TAITime() {
        if (libFound) {
            TimeStorage storage = this.getTime();
            this.leapSeconds = storage.getTimeSecsTAI() - storage.getTimeSecsUTC();
            this.leapSecondsAreReasonable = this.leapSeconds >= (long)minLeapSeconds;
        } else {
            this.leapSeconds = 0L;
            this.leapSecondsAreReasonable = false;
        }
    }

    boolean isConfigured() {
        if (strict) {
            if (!libFound) {
                throw new RuntimeException("Kernel library could not be loaded", loadException);
            }
            if (!this.leapSecondsAreReasonable) {
                throw new RuntimeException("Kernal leap second offset was too small: " + this.leapSeconds + "<" + minLeapSeconds);
            }
        }
        return libFound && this.leapSecondsAreReasonable;
    }

    private native void timeaccess(TimeStorage var1);

    final TimeStorage getTime() {
        TimeStorage result = new TimeStorage();
        this.timeaccess(result);
        return result;
    }

    static {
        strict = Boolean.getBoolean("org.lsst.ccs.utilities.taitime.useStrict");
        libName = System.getProperty("org.lsst.ccs.utilities.taitime.libName", "timeaccess");
        minLeapSeconds = Integer.getInteger("org.lsst.ccs.utilities.taitime.minLeapSeconds", 30);
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            libFound = false;
            loadException = e;
            logger.log(Level.WARNING, "c++ shared library {0} not found !", libName);
        }
    }
}

