/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.gconsole.plugins.dictionary.AgentDefaultTableModel;
import org.lsst.ccs.gconsole.plugins.dictionary.AgentDictionaries;

public class AgentDictionaryTable
extends JTable
implements ItemListener {
    private static final String[] COLUMN_NAMES = new String[]{"Agent name", "Lock", "Level"};
    private AgentDefaultTableModel tableModel = new AgentDefaultTableModel(COLUMN_NAMES);
    private TableRowSorter<AgentDefaultTableModel> sorter = new TableRowSorter<AgentDefaultTableModel>(this.tableModel);
    private boolean[] checkSelected = new boolean[AgentInfo.AgentType.values().length];
    private final RouteSelectionCommandSet rsc;

    public AgentDictionaryTable(RouteSelectionCommandSet commandSet) {
        this.setModel(this.tableModel);
        this.setRowSorter(this.sorter);
        this.getColumn(COLUMN_NAMES[0]).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    AgentDictionaries ds = (AgentDictionaries)value;
                    this.setText(ds.ai.getName());
                    this.setToolTipText(ds.ai.getName());
                }
                return this;
            }
        });
        this.getColumn(COLUMN_NAMES[1]).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setHorizontalAlignment(0);
                if (((Boolean)value).booleanValue()) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("ic_lock_black_18dp.png"), "locked"));
                } else {
                    this.setIcon(new ImageIcon(this.getClass().getResource("ic_lock_open_black_18dp.png"), "unlocked"));
                }
                return this;
            }
        });
        this.getColumn(COLUMN_NAMES[0]).setMinWidth(150);
        this.setRowHeight(27);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.rsc = commandSet;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox checkBox = (JCheckBox)e.getSource();
        String name = checkBox.getName();
        AgentInfo.AgentType type = AgentInfo.AgentType.valueOf((String)name);
        this.checkSelected[type.ordinal()] = checkBox.isSelected();
        ArrayList<3> filterList = new ArrayList<3>();
        for (final AgentInfo.AgentType agentType : AgentInfo.AgentType.values()) {
            if (!this.checkSelected[agentType.ordinal()]) continue;
            filterList.add(new RowFilter<AgentDefaultTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends AgentDefaultTableModel, ? extends Integer> entry) {
                    AgentInfo agent = ((AgentDictionaries)entry.getModel().getValueAt((int)entry.getIdentifier().intValue(), (int)0)).ai;
                    return agent.getType().equals((Object)agentType);
                }
            });
        }
        RowFilter filter = RowFilter.orFilter(filterList);
        this.sorter.setRowFilter(filter);
    }

    AgentDictionaries getSelectedAgentDictionaries() {
        if (this.getSelectedRow() >= 0) {
            AgentDictionaries ds = (AgentDictionaries)this.getValueAt(this.getSelectedRow(), 0);
            ds.update(this.rsc);
            return ds;
        }
        return null;
    }

    public void addAgentToList(AgentInfo ai) {
        ((DefaultTableModel)this.getModel()).addRow(new Object[]{new AgentDictionaries(ai)});
    }

    public void removeAgentFromList(AgentInfo ai) {
        ((AgentDefaultTableModel)this.getModel()).removeRow(ai);
    }

    public void updateAgentsList(List<AgentInfo> ais) {
        Object[][] data = new Object[ais.size()][1];
        for (int i = 0; i < ais.size(); ++i) {
            AgentInfo ai = ais.get(i);
            data[i][0] = new AgentDictionaries(ai);
        }
        ((AgentDefaultTableModel)this.getModel()).update(data);
    }

    void updateLevelForAgent(String agentName, int level) {
        ((AgentDefaultTableModel)this.getModel()).updateLevelForAgent(agentName, level);
    }

    void updateLockForAgent(String agentName, boolean locked) {
        ((AgentDefaultTableModel)this.getModel()).updateLockForAgent(agentName, locked);
    }
}

