/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.plugins.dictionary.AgentDictionaries;
import org.lsst.ccs.gconsole.plugins.dictionary.ComponentDictionary;
import org.lsst.ccs.utilities.structs.TreeBranch;

public class DictionaryTreePanel
extends JTree {
    private static final long serialVersionUID = -3173309107169865621L;
    private TreeBranch<ComponentDictionary> dictionaryTree;
    private final CommandTreeRenderer renderer;

    DictionaryTreePanel() {
        this.setModel(new DefaultTreeModel((TreeNode)this.dictionaryTree));
        this.getSelectionModel().setSelectionMode(1);
        this.renderer = new CommandTreeRenderer();
        this.setCellRenderer(this.renderer);
    }

    void updateData(AgentDictionaries dict) {
        new BuildDictionaryWorker(dict).execute();
    }

    public void updateRenderer() {
        this.revalidate();
        this.repaint();
    }

    private class CommandTreeRenderer
    extends DefaultTreeCellRenderer {
        private CommandTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            this.setForeground(this.greyOut((TreeBranch<ComponentDictionary>)((TreeBranch)value)) ? Color.GRAY : Color.BLACK);
            return this;
        }

        private boolean greyOut(TreeBranch<ComponentDictionary> tree) {
            for (TreeBranch child : tree.getChildren()) {
                if (this.greyOut((TreeBranch<ComponentDictionary>)child)) continue;
                return false;
            }
            Dictionary d = ((ComponentDictionary)tree.getContent()).dictionary;
            for (DictionaryCommand dc : d) {
                if (dc.getLevel() > d.getLevel() || !d.getVisibilityForType(dc.getType())) continue;
                return false;
            }
            return true;
        }
    }

    private class BuildDictionaryWorker
    extends SwingWorker<TreeBranch<ComponentDictionary>, String> {
        private final AgentDictionaries dict;

        BuildDictionaryWorker(AgentDictionaries dict) {
            this.dict = dict;
        }

        @Override
        protected TreeBranch<ComponentDictionary> doInBackground() {
            try {
                HashMap<String, Dictionary> dictionaries = new HashMap<String, Dictionary>(this.dict.dictionaries);
                Map<String, CommandSet> commandSets = this.dict.commandSets;
                TreeBranch dictionaryTree = null;
                String rootName = this.dict.ai.getName();
                Dictionary rootDictionary = (Dictionary)dictionaries.remove(rootName);
                TreeBranch treeWalker = dictionaryTree = new TreeBranch((Serializable)new ComponentDictionary(rootName, rootName, rootDictionary, commandSets.get(rootName)));
                for (Map.Entry entry : dictionaries.entrySet()) {
                    treeWalker = dictionaryTree;
                    String[] pathTab = ((String)entry.getKey()).split("/");
                    for (int i = 1; i < pathTab.length; ++i) {
                        boolean found = false;
                        if (treeWalker.getChildren() != null) {
                            Iterator it = treeWalker.getChildIterator();
                            while (it.hasNext() && !found) {
                                TreeBranch currIt = (TreeBranch)it.next();
                                if (!((ComponentDictionary)currIt.getContent()).name.equals(pathTab[i])) continue;
                                treeWalker = currIt;
                                found = true;
                                if (i != pathTab.length - 1) continue;
                                treeWalker.setContent((Serializable)new ComponentDictionary((String)entry.getKey(), pathTab[i], (Dictionary)entry.getValue(), commandSets.get(entry.getKey())));
                            }
                        }
                        if (found) continue;
                        treeWalker = new TreeBranch(treeWalker, (Serializable)new ComponentDictionary((String)entry.getKey(), pathTab[i], (Dictionary)entry.getValue(), commandSets.get(entry.getKey())));
                    }
                }
                TreeBranch root = dictionaryTree;
                this.removeLeafsWithEmptyDicts((TreeBranch<ComponentDictionary>)root);
                return dictionaryTree;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }

        private void removeLeafsWithEmptyDicts(TreeBranch<ComponentDictionary> node) {
            Iterator it = node.getChildIterator();
            while (it.hasNext()) {
                TreeBranch currIt = (TreeBranch)it.next();
                this.removeLeafsWithEmptyDicts((TreeBranch<ComponentDictionary>)currIt);
                if (currIt.getChildCount() != 0 || ((ComponentDictionary)currIt.getContent()).dictionary.iterator().hasNext()) continue;
                it.remove();
            }
        }

        @Override
        public void done() {
            try {
                DictionaryTreePanel.this.dictionaryTree = (TreeBranch)this.get();
                if (DictionaryTreePanel.this.dictionaryTree != null) {
                    DictionaryTreePanel.this.setModel(new DefaultTreeModel((TreeNode)DictionaryTreePanel.this.dictionaryTree));
                    DictionaryTreePanel.this.getSelectionModel().setSelectionPath(new TreePath(DictionaryTreePanel.this.getModel().getRoot()));
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                ex.printStackTrace();
            }
        }
    }
}

