package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Color;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.lsst.ccs.Agent;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

/**
 * 
 * @author emarin
 */
public class DictionaryBusMaster {
    
    private final DictionaryTreeMainPanel mainPanel;
    
    private final AgentMessagingLayer messagingAccess;
    
    private final ConsoleCommandShell comShell;
    
    private final RouteSelectionCommandSet commandSet;
    
    private final Agent agent;
    
    public DictionaryBusMaster(Agent a) {
        this.agent = a;
        
        this.messagingAccess = a.getMessagingAccess();
        
        comShell = ConsoleCommandShell.createConsoleCommandShell(a);
        
        commandSet = comShell.getConsoleCommandSet();
        
        mainPanel = new DictionaryTreeMainPanel(messagingAccess, commandSet, a.getAgentLockService());
        
    }
    
    public DictionaryTreeMainPanel getMainPane(){
        return mainPanel;
    }
    
    public void initGUI() {
        messagingAccess.getAgentPresenceManager().addAgentPresenceListener(mainPanel);
        agent.getAgentLockService().addAgentLevelListener(mainPanel);
        agent.getAgentLockService().addAgentLockUpdateListener(mainPanel);
    }
    
    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Refresh");
        menuItem.setBackground(Color.LIGHT_GRAY);
        menu.add(menuItem);
        return menuBar;
    }
    
    /**
     * Called by the shutdown method of Subsystem
     */
    public void doShutdown(){
        messagingAccess.getAgentPresenceManager().removeAgentPresenceListener(mainPanel);
    }
}
