package org.lsst.ccs.gconsole.plugins.dictionary;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;

/**
 *
 * @author emarin
 */
class AgentDictionaries implements Serializable {
    
    final AgentInfo ai;
    
    final Map<String, Dictionary> dictionaries = new HashMap<>();
    
    final Map<String, CommandSet> commandSets = new HashMap<>();
    
    AgentDictionaries(AgentInfo ai) {
        this.ai = ai;
    }
    
    void update(RouteSelectionCommandSet rsc) {
        commandSets.clear();
        dictionaries.clear();
        for(Map.Entry<String, CommandSet> entry : rsc.getCommandSetsForRoute(ai.getName()).entrySet()) {
            commandSets.put(entry.getKey(), entry.getValue());
            dictionaries.put(entry.getKey(), entry.getValue().getCommandDictionary());
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.ai);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final AgentDictionaries other = (AgentDictionaries) obj;
        if (!Objects.equals(this.ai, other.ai)) {
            return false;
        }
        return true;
    }
    
    
}
