package org.lsst.ccs.gconsole.plugins.demo.monitor.image;

import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

class FrontPage implements OptionalPage {

// -- Fields : -----------------------------------------------------------------

    private ImageView imageView;

// -- Life cycle : -------------------------------------------------------------
    
// -- Implementing OptionalPage : ----------------------------------------------

    @Override
    public boolean isAutoOpen() {
        return true;
    }

    @Override
    public String getPath() {
        return "CCS Subsystems/Refrigeration";
    }

    @Override
    public String getPage(AgentInfo agent) {
        return agent.getName().equals("demo-subsystem-with-monitoring") ? "Main" : null;
    }

    @Override
    public JComponent open(AgentInfo agent, JComponent existingComponent) {
        try {
            
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/refrig.png"));
            imageView = new ImageView("ImageView test", back, .5, 2.);
            
            ImageView.Item item;
            CellTableView table;
            
            DefaultChannelHandle handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel0", null, null);
            FormattedValue fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            MonitorField field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            MonitorCell c0 = new MonitorCell(handle, field);
            
            handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", null, null);
            fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            MonitorCell c1 = new MonitorCell(handle, field);
            
            handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel2", null, null);
            fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            MonitorCell c2 = new MonitorCell(handle, field);
            
            handle = new DefaultChannelHandle("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel3", null, null);
            fv = new FormattedValue();
            fv.horizontalAlignment = SwingUtilities.CENTER;
            field = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
            MonitorCell c3 = new MonitorCell(handle, field);
            table = new CellTableView(2, 2, c0, c1, c2, c3);
            table.setEqualRows(true);
            table.setEqualColumns(true);
            item = new ImageView.Item(table);
            item.setPosition(0.2948, 0.0972);
            item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            item.setSize(0.0813, 0.1084);
            item.setMaxSize(0.1167, 0.1333);
            imageView.add(item);

            BufferedImage cir = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/circle.png"));
            item = new ImageView.Item(cir);
            item.setPosition(0.2948, 0.0972);
            item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            item.setSize(25, 25);
            item.setLayer(3);
            imageView.add(item);

            return imageView.getPanel();
        } catch (Exception e) {
            e.printStackTrace();
            return new JLabel(e.toString());
        }
    }

    @Override
    public void opened(String page) {
        imageView.install();
    }

    @Override
    public void closed(String page) {
        imageView.uninstall();
    }

}
