package org.lsst.ccs.gconsole.plugins.alert;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;

/**
 * Alert handling service implementation.
 *
 * @author onoprien
 */
public class AlertHandler implements AlertService {
    
// -- Fields : -----------------------------------------------------------------
    
    private final org.lsst.ccs.services.alert.AlertService alertService;
    
// -- Lifecycle : --------------------------------------------------------------
    
    public AlertHandler(LsstAlertPlugin plugin) {
        this.alertService = plugin.getConsole().getAlertService();
    }


// -- Processing alerts : ------------------------------------------------------

    @Override
    synchronized public void submitAlert(String source, Alert alert, AlertState level, String cause) {
        if (source == null || source.isEmpty()) {
            source = "Local";
        } else if (!source.startsWith("Local")) {
            source = "Local : "+ source;
        }
                
        if ( level == AlertState.NOMINAL ) {
            //Check if there are any other raised alerts for this source/id.
            //If not don't do anything.
            RaisedAlertSummary summary = alertService.getSummary(source);
            if ( summary == null || summary.getRaisedAlert(alert.getAlertId()) == null) {
                return;
            }
            alertService.clearAlertsForSource(source, alert.getAlertId());
        } else {
            alertService.raiseAlert(source, alert, level, cause);
        }
    }

    
    @Override
    public void addListener(AlertListener listener) {
        alertService.addListener(listener);
    }

    @Override
    public void removeListener(AlertListener listener) {
        alertService.removeListener(listener);
    }
    
    
// -- Getters : ----------------------------------------------------------------

    @Override
    public RaisedAlertSummary getSummary(String source) {
        return alertService.getSummary(source);
    }
    
    
    
}
