package org.lsst.ccs.subsystem.monitor.ui;

import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

/**
 * Common interface to {@link MonitorTrendingTable} and {@link MonitorTrendingTree}.
 *
 * @author onoprien
 */
public interface MonitorTrendingView {
    
    void setSubsystems(String... sNames);
    
    void updateTableModel(String sName, MonitorFullState status);
    
    void updateTableValue(String sName, String cName, double value);
    
    void updateTableLimit(String sName, String cName, String limName, String value);
    
    void updateTableState(String sName, MonitorState status);
    
    void disableSystem(String sName);
    
}
