package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

/**
 *
 * @author emarin
 */
public class EngineeringModeButtonEditor extends AbstractCellEditor implements TableCellEditor, ActionListener, ListSelectionListener {
    private JButton button;
    private boolean value;
    
    public EngineeringModeButtonEditor(AgentDictionaryTable table) {
        button = new JButton();
        button.setOpaque(true);
        button.addActionListener(this);
    }
    
    public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {
        
        this.value = (boolean)value;
        String s;
        if ((boolean)value){
            s = "/org/lsst/ccs/gconsole/plugins/jas3/dictionary/ic_settings_red_18dp.png";
        }
        else {
            s = "/org/lsst/ccs/gconsole/plugins/jas3/dictionary/ic_settings_black_18dp.png";
        }
        button.setIcon(new ImageIcon(this.getClass().getResource(s)));
        button.setToolTipText("switch to Engineering/Normal mode");
        return button;
    }
    
    @Override
    /**
     * Returns the value edited and sets it into the model once fireEditingStopped
     * is fired
     */
    public Object getCellEditorValue() {
        System.out.println("getcelleditorvalue " + button.isSelected());
        //return button.isSelected();
        return value;
    }
    
    @Override
    public void actionPerformed(ActionEvent e) {
        // 
        fireEditingStopped();
        
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {

    }

}
