package org.lsst.ccs.gconsole.plugins.dictionary;

import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.bus.data.AgentInfo;

/**
 *
 * @author emarin
 */
class AgentDefaultTableModel extends DefaultTableModel {

    private final Class<?>[] COLUMN_TYPES = new Class[]{AgentDictionaries.class, Boolean.class, Integer.class};
    
    AgentDefaultTableModel(Object[] columnNames){
        super(columnNames, 0);
    }
    
    // Needed by the renderer
    @Override 
    public Class getColumnClass(int c){
        return COLUMN_TYPES[c];
    }
    
    public void update(Object[][] data){
        Object[][] currentTab = new Object[getDataVector().size()][1];
        for (int i = 0; i<getDataVector().size();i++){
            currentTab[i][0]=getValueAt(i, 0);
        }
        
        // To be removed
        for (int i=0;i<currentTab.length;i++){
            boolean found = false;
            for (int j=0;i<data.length;j++){
                // equals is overriden in Agent
                if (data[j][0].equals(data[i][0])){
                    found = true;
                    break;
                }
            }
            if (!found){
                removeRow(((AgentDictionaries)currentTab[i][0]).ai);
                //toBeRemoved.add(currentTab[i]);
            }
        }
        
        // Search for the ones to be added
        for (int i=0;i<data.length;i++){
            boolean found=false;
            for (int j=0;j<currentTab.length;j++){
                if (currentTab[j][0].equals(data[i][0])){
                    found=true;
                    break;
                }
            }
            if (!found){
                addRow(data[i]);
            }
        }
//        
//        setRowCount(0);
//        for(int i=0;i<data.length;i++){
//            addRow(data[i]);
//        }
    }
    
    @Override
    public boolean isCellEditable(int row, int col){
        return false;
    }
    
    public void removeRow(AgentInfo ai){
        for (int i=0;i<getRowCount();i++){
            if (ai.equals(((AgentDictionaries)getValueAt(i, 0)).ai)){
                removeRow(i);
                return;
            }
        }
    }
    
    public void updateLevelForAgent(String agentName, int level) {
        AgentDictionaries ad = null;
        for (int i = 0; i<getDataVector().size();i++){
            ad = (AgentDictionaries)getValueAt(i, 0);
            if (ad.ai.getName().equals(agentName)) {
                setValueAt(level, i, 2);
                return;
            } 
        }
    }
    
    public void updateLockForAgent(String agentName, boolean locked) {
        AgentDictionaries ad = null;
        for (int i = 0; i<getDataVector().size();i++){
            ad = (AgentDictionaries)getValueAt(i, 0);
            if (ad.ai.getName().equals(agentName)) {
                setValueAt(locked, i, 1);
                return;
            }
        }
    }
}
