/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager2;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.CellView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public class ImageView
implements MonitorView {
    public static final float MAX_SCALE = 2.0f;
    public static final float MIN_SCALE = 0.5f;
    private String name;
    private BufferedImage back;
    private float minScale;
    private float maxScale;
    private final ArrayList<Item> items = new ArrayList();
    private JScrollPane scrollPane;
    private Panel viewPanel;
    private JLayeredPane layers;
    private ImagePanel backPanel;

    public ImageView(String name, BufferedImage image) {
        this(name, image, 0.5, 2.0);
    }

    public ImageView(String name, BufferedImage image, double minScale, double maxScale) {
        this.name = name;
        this.back = image;
        this.minScale = (float)minScale;
        this.maxScale = (float)maxScale;
    }

    public ImageView(String name, BufferedImage image, Dimension minSize, Dimension maxSize) {
        this.name = name;
        this.back = image;
        float w = image.getWidth();
        float h = image.getHeight();
        this.minScale = Math.max((float)minSize.width / w, (float)minSize.height / h);
        this.maxScale = Math.min((float)maxSize.width / w, (float)maxSize.height / h);
    }

    public void add(Item item) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Items cannot be added once the image view has been displayed");
        }
        this.items.add(item);
    }

    private void initialize() {
        this.layers = new JLayeredPane();
        float originalWidth = this.back.getWidth();
        float originalHeight = this.back.getHeight();
        for (Item item : this.items) {
            item.norm(originalWidth, originalHeight);
            JComponent component = item.getComponent();
            if (component == null) continue;
            this.layers.add((Component)component, (Object)item.getLayer());
        }
        this.backPanel = new ImagePanel(this.back);
        this.backPanel.setOpaque(true);
        this.layers.add((Component)this.backPanel, (Object)0);
        this.backPanel.setLocation(0, 0);
        this.viewPanel = new Panel();
        this.viewPanel.add(this.layers);
        this.scrollPane = new JScrollPane(this.viewPanel);
    }

    private boolean isInitialized() {
        return this.viewPanel != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JComponent getPanel() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        return this.scrollPane;
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return null;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
    }

    @Override
    public void install() {
        this.items.forEach(item -> {
            Object content = item.getContent();
            if (content instanceof MonitorView) {
                ((MonitorView)content).install();
            }
        });
    }

    @Override
    public void uninstall() {
        this.items.forEach(item -> {
            Object content = item.getContent();
            if (content instanceof MonitorView) {
                ((MonitorView)content).uninstall();
            }
        });
    }

    @Override
    public MonitorView.Descriptor save() {
        return MonitorView.super.save();
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        MonitorView.super.restore(descriptor);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> ImageView.createAndShowGUI());
    }

    private static void createAndShowGUI() {
        System.out.println("Starting... ");
        JFrame f = new JFrame("ImageView test");
        f.setDefaultCloseOperation(3);
        try {
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/grid.png"));
            ImageView imageView = new ImageView("ImageView test", back, 0.5, 2.0);
            CellTableView.Cell c0 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel0");
            CellTableView.Cell c1 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
            CellTableView.Cell c2 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel2");
            CellTableView.Cell c3 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel3");
            CellTableView t = new CellTableView(2, 2, c0, c1, c2, c3);
            Item item = new Item(t);
            item.setPosition(40.0, 399.0);
            item.setAlignment(0.0, 0.0);
            item.setMaxSize(471.0, 246.0);
            item.setMinWidth(108.0);
            imageView.add(item);
            BufferedImage demo = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/demo.png"));
            item = new Item(demo);
            item.setPosition(0.0, 0.0);
            item.setAlignment(0.0, 0.0);
            item.setSize(1.0, 1.0);
            item.setLayer(2);
            imageView.add(item);
            BufferedImage cir = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/circle.png"));
            item = new Item(cir);
            item.setPosition(40.0, 399.0);
            item.setAlignment(0.5, 0.5);
            item.setSize(25.0, 25.0);
            item.setLayer(3);
            imageView.add(item);
            f.add(imageView.getPanel());
            f.pack();
            f.setVisible(true);
        }
        catch (IOException e) {
            System.out.println("Failed: " + e);
        }
    }

    public static class Item {
        Object content;
        float x;
        float y;
        float width = -1.0f;
        float height = -1.0f;
        float maxWidth = -1.0f;
        float maxHeight = -1.0f;
        float minWidth = -1.0f;
        float minHeight = -1.0f;
        float alignmentX = -1.0f;
        float alignmentY = -1.0f;
        int layer = 1;

        public Item() {
        }

        public Item(Object content) {
            this.content = content;
        }

        void norm(float backWidth, float backHeight) {
            if (this.content instanceof BufferedImage) {
                BufferedImage image = (BufferedImage)this.content;
                this.content = new ImagePanel(image);
            } else if (this.content instanceof String) {
                this.content = new CellView((String)this.content);
            }
            if (this.x < 0.0f || this.y < 0.0f || this.x > backWidth || this.y > backHeight) {
                throw new IllegalArgumentException();
            }
            if (this.x > 1.0f) {
                this.x /= backWidth;
            }
            if (this.y > 1.0f) {
                this.y /= backHeight;
            }
            if (this.width > backWidth || this.height > backHeight) {
                throw new IllegalArgumentException();
            }
            if (this.width > 1.0f) {
                this.width /= backWidth;
            }
            if (this.height > 1.0f) {
                this.height /= backHeight;
            }
            if (this.maxWidth > backWidth || this.maxHeight > backHeight) {
                throw new IllegalArgumentException();
            }
            if (this.maxWidth > 1.0f) {
                this.maxWidth /= backWidth;
            } else if (this.maxWidth < 0.0f) {
                this.maxWidth = 10.0f;
            }
            if (this.maxHeight > 1.0f) {
                this.maxHeight /= backHeight;
            } else if (this.maxHeight < 0.0f) {
                this.maxHeight = 10.0f;
            }
            if (this.minWidth > backWidth || this.height > backHeight) {
                throw new IllegalArgumentException();
            }
            if (this.minWidth > 1.0f) {
                this.minWidth /= backWidth;
            }
            if (this.minHeight > 1.0f) {
                this.minHeight /= backHeight;
            }
            if (this.layer < 1) {
                throw new IllegalArgumentException();
            }
        }

        public Object getContent() {
            return this.content;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public float getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = (float)x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = (float)y;
        }

        public float getWidth() {
            return this.width;
        }

        public void setWidth(double width) {
            this.width = (float)width;
        }

        public float getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = (float)height;
        }

        public float getMinWidth() {
            return this.minWidth;
        }

        public void setMinWidth(double minWidth) {
            this.minWidth = (float)minWidth;
        }

        public float getMinHeight() {
            return this.minHeight;
        }

        public void setMinHeight(double minHeight) {
            this.minHeight = (float)minHeight;
        }

        public float getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(double maxWidth) {
            this.maxWidth = (float)maxWidth;
        }

        public float getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxHeight(double maxHeight) {
            this.maxHeight = (float)maxHeight;
        }

        public float getAlignmentX() {
            return this.alignmentX;
        }

        public void setAlignmentX(double alignmentX) {
            this.alignmentX = (float)alignmentX;
        }

        public float getAlignmentY() {
            return this.alignmentY;
        }

        public void setAlignmentY(double alignmentY) {
            this.alignmentY = (float)alignmentY;
        }

        public int getLayer() {
            return this.layer;
        }

        public void setLayer(int layer) {
            this.layer = layer;
        }

        public void setPosition(double x, double y) {
            this.setX(x);
            this.setY(y);
        }

        public void setSize(double width, double height) {
            this.setWidth(width);
            this.setHeight(height);
        }

        public void setMinSize(double width, double height) {
            this.setMinWidth(width);
            this.setMinHeight(height);
        }

        public void setMaxSize(double width, double height) {
            this.setMaxWidth(width);
            this.setMaxHeight(height);
        }

        public void setAlignment(double alignmentX, double alignmentY) {
            this.setAlignmentX(alignmentX);
            this.setAlignmentY(alignmentY);
        }

        JComponent getComponent() {
            if (this.content instanceof MonitorView) {
                return ((MonitorView)this.content).getPanel();
            }
            if (this.content instanceof JComponent) {
                return (JComponent)this.content;
            }
            return null;
        }
    }

    static final class ImagePanel
    extends JPanel {
        private final BufferedImage image;
        private Image imageScaled;
        private int xSize;
        private int ySize;

        ImagePanel(BufferedImage image) {
            this.image = image;
            this.setAlignmentX(0.5f);
            this.setAlignmentY(0.5f);
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int widthCurrent = this.getWidth();
            int heightCurrent = this.getHeight();
            if (widthCurrent == this.xSize && heightCurrent == this.ySize) {
                g.drawImage(this.imageScaled, 0, 0, null);
            } else {
                this.xSize = widthCurrent;
                this.ySize = heightCurrent;
                this.imageScaled = this.scale(this.image, this.xSize, this.ySize);
                g.drawImage(this.imageScaled, 0, 0, null);
            }
        }

        private Image scale(BufferedImage source, int width, int height) {
            return source.getScaledInstance(width, height, 4);
        }
    }

    private class Layout
    implements LayoutManager2 {
        private Dimension minBackSize;
        private Dimension maxBackSize;
        private final float originalWidth;
        private final float originalHeight;
        private Dimension viewSize;
        private float scale;
        private int backX;
        private int backY;
        private int backWidth;
        private int backHeight;
        private int w;
        private int h;
        private Item item;
        private Dimension pref;
        private Dimension min;
        private Dimension max;
        private Item scaleChangeItem;
        private int modified;

        Layout() {
            this.originalWidth = ImageView.this.back.getWidth();
            this.originalHeight = ImageView.this.back.getHeight();
            this.minBackSize = new Dimension(Math.round(this.originalWidth * ImageView.this.minScale), Math.round(this.originalHeight * ImageView.this.minScale));
            this.maxBackSize = new Dimension(Math.round(this.originalWidth * ImageView.this.maxScale), Math.round(this.originalHeight * ImageView.this.maxScale));
            this.viewSize = new Dimension(ImageView.this.back.getWidth(), ImageView.this.back.getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            Container viewport;
            for (viewport = ImageView.this.viewPanel.getParent(); viewport != null && !(viewport instanceof JViewport); viewport = viewport.getParent()) {
            }
            if (viewport == null) {
                return;
            }
            this.w = viewport.getWidth();
            this.h = viewport.getHeight();
            if (this.w == this.viewSize.width && this.h == this.viewSize.height && this.backWidth != 0 || this.w == 0 || this.h == 0) {
                return;
            }
            this.viewSize.width = this.w;
            this.viewSize.height = this.h;
            ImageView.this.viewPanel.setSize(this.viewSize);
            if (this.viewSize.width <= this.minBackSize.width || this.viewSize.height <= this.minBackSize.height) {
                this.scale = ImageView.this.minScale;
                this.w = this.minBackSize.width;
                this.h = this.minBackSize.height;
            } else if (this.viewSize.width >= this.maxBackSize.width && this.viewSize.height >= this.maxBackSize.height) {
                this.scale = ImageView.this.maxScale;
                this.w = this.maxBackSize.width;
                this.h = this.maxBackSize.height;
            } else {
                this.scale = Math.min((float)this.viewSize.width / this.originalWidth, (float)this.viewSize.height / this.originalHeight);
                this.w = Math.round(this.originalWidth * this.scale);
                this.h = Math.round(this.originalHeight * this.scale);
            }
            if (this.w == this.backWidth && this.h == this.backHeight) {
                this.backX = Math.max((this.viewSize.width - this.w) / 2, 0);
                this.backY = Math.max((this.viewSize.height - this.h) / 2, 0);
                ImageView.this.layers.setLocation(this.backX, this.backY);
                return;
            }
            this.backWidth = Math.round(this.originalWidth * this.scale);
            this.backHeight = Math.round(this.originalHeight * this.scale);
            this.scaleChangeItem = null;
            block3: do {
                this.modified = 0;
                try {
                    Iterator it = ImageView.this.items.iterator();
                    while (it.hasNext()) {
                        boolean done;
                        boolean bl = done = this.scaleChangeItem != null && this.scaleChangeItem == this.item;
                        if (done) {
                            this.scaleChangeItem = null;
                        }
                        this.item = (Item)it.next();
                        this.layoutItem();
                        if (!done) continue;
                        continue block3;
                    }
                }
                catch (IllegalStateException x) {
                    int big = 0x7FFFFFF5;
                    if (this.maxBackSize.width >= big) {
                        throw new RuntimeException("Failure of ImageView layout: " + ImageView.this.getName());
                    }
                    this.maxBackSize = new Dimension(big, big);
                    this.item.getComponent().setMaximumSize(this.maxBackSize);
                }
            } while (this.modified != 0);
            this.backX = Math.max((this.viewSize.width - this.backWidth) / 2, 0);
            this.backY = Math.max((this.viewSize.height - this.backHeight) / 2, 0);
            ImageView.this.backPanel.setSize(this.backWidth, this.backHeight);
            ImageView.this.layers.setBounds(this.backX, this.backY, this.backWidth, this.backHeight);
        }

        private void layoutItem() {
            JComponent component = this.item.getComponent();
            if (component == null) {
                return;
            }
            this.pref = component.getPreferredSize();
            this.min = component.getMinimumSize();
            this.max = component.getMaximumSize();
            if (this.item.getWidth() > 0.0f) {
                this.w = Math.round((float)this.backWidth * this.item.getWidth());
                if (this.w < this.min.width) {
                    this.w = this.min.width;
                    this.checkWidth(1);
                } else if (this.w > this.max.width) {
                    this.w = this.max.width;
                    this.checkWidth(-1);
                }
            } else {
                this.w = this.pref.width;
                int wMin = Math.round((float)this.backWidth * this.item.getMinWidth());
                if (this.w < wMin) {
                    this.w = wMin;
                    this.checkWidth(-1);
                } else {
                    int wMax = Math.round((float)this.backWidth * this.item.getMaxWidth());
                    if (this.w > wMax) {
                        this.w = wMax;
                        this.checkWidth(1);
                    }
                }
            }
            if (this.item.getHeight() > 0.0f) {
                this.h = Math.round((float)this.backHeight * this.item.getHeight());
                if (this.h < this.min.height) {
                    this.h = this.min.height;
                    this.checkHeight(1);
                } else if (this.w > this.max.height) {
                    this.h = this.max.height;
                    this.checkHeight(-1);
                }
            } else {
                this.h = this.pref.height;
                int hMin = Math.round((float)this.backHeight * this.item.getMinHeight());
                if (this.h < hMin) {
                    this.h = hMin;
                    this.checkHeight(-1);
                } else {
                    int hMax = Math.round((float)this.backHeight * this.item.getMaxHeight());
                    if (this.h > hMax) {
                        this.h = hMax;
                        this.checkHeight(1);
                    }
                }
            }
            if (this.item != this.scaleChangeItem) {
                float align = this.item.getAlignmentX() < 0.0f ? component.getAlignmentX() : this.item.getAlignmentX();
                int x = Math.round((float)this.backWidth * this.item.getX() - (float)this.w * align);
                align = this.item.getAlignmentY() < 0.0f ? component.getAlignmentY() : this.item.getAlignmentY();
                int y = Math.round((float)this.backHeight * this.item.getY() - (float)this.h * align);
                component.setBounds(x, y, this.w, this.h);
            }
        }

        private void checkWidth(int direction) {
            if (direction == -this.modified) {
                throw new IllegalStateException();
            }
            if (direction > 0) {
                int wMax = Math.round((float)this.backWidth * this.item.getMaxWidth());
                if (wMax < this.min.width) {
                    this.backWidth = Math.round((float)this.min.width / this.item.getMaxWidth() + 0.5f);
                    this.scaleChangeItem = this.item;
                }
            } else {
                int wMin = Math.round((float)this.backWidth * this.item.getMinWidth());
                if (wMin > this.max.width) {
                    this.backWidth = Math.round((float)this.max.width / this.item.getMinWidth() - 0.5f);
                    this.scaleChangeItem = this.item;
                }
            }
            if (this.scaleChangeItem == this.item) {
                this.modified = direction;
                this.scale = (float)this.backWidth / this.originalWidth;
                this.backHeight = Math.round(this.originalHeight * this.scale);
            }
        }

        private void checkHeight(int direction) {
            if (direction == -this.modified) {
                throw new IllegalStateException();
            }
            if (direction > 0) {
                int hMax = Math.round((float)this.backHeight * this.item.getMaxHeight());
                if (hMax < this.min.height) {
                    this.backHeight = Math.round((float)this.min.height / this.item.getMaxHeight() + 0.5f);
                    this.scaleChangeItem = this.item;
                }
            } else {
                int hMin = Math.round((float)this.backHeight * this.item.getMinHeight());
                if (hMin > this.max.height) {
                    this.backHeight = Math.round((float)this.max.height / this.item.getMinHeight() - 0.5f);
                    this.scaleChangeItem = this.item;
                }
            }
            if (this.scaleChangeItem == this.item) {
                this.modified = direction;
                this.scale = (float)this.backHeight / this.originalHeight;
                this.backWidth = Math.round(this.originalHeight * this.scale);
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.layoutContainer(parent);
            return this.viewSize.width < this.minBackSize.width || this.viewSize.height < this.minBackSize.height ? this.minBackSize : this.viewSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.minBackSize;
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.maxBackSize;
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }

    private final class Panel
    extends JPanel {
        Panel() {
            super(new Layout());
            this.setName("Root");
        }

        @Override
        public void validate() {
            this.invalidate();
            super.validate();
        }
    }
}

