/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public class CellTableView
extends JTable
implements MonitorView,
AgentChannelsFilter {
    private final int nRows;
    private final int nColumns;
    private final ArrayList<Cell> cells;
    private final Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public CellTableView(int rows, int columns, Cell ... content) {
        if (rows * columns != content.length) {
            throw new IllegalArgumentException("Incorrect number of cell descriptors");
        }
        this.nRows = rows;
        this.nColumns = columns;
        this.cells = new ArrayList(rows * columns);
        for (Cell cell : content) {
            this.cells.add(cell);
        }
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setShowGrid(true);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        MonitorTableCellRenderer renderer = new MonitorTableCellRenderer();
        renderer.setEnsureWidth(true);
        renderer.setEnsureHeight(true);
        this.setDefaultRenderer(Object.class, renderer);
        this.setModel(new Model());
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return this;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
    }

    @Override
    public MonitorView.Descriptor save() {
        return MonitorView.super.save();
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        MonitorView.super.restore(descriptor);
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    private void update(AgentStatusEvent event) {
        String path;
        block0: for (AgentChannel channel : event.getAddedChannels()) {
            path = channel.getPath();
            for (Cell cell : this.cells) {
                if (!cell.path.equals(path)) continue;
                cell.channel = channel;
                this.format(cell);
                continue block0;
            }
        }
        block2: for (AgentChannel channel : event.getRemovedChannels()) {
            path = channel.getPath();
            for (Cell cell : this.cells) {
                if (!cell.path.equals(path)) continue;
                cell.channel = null;
                this.format(cell);
                continue block2;
            }
        }
        block4: for (AgentChannel channel : event.getStatusChanges().keySet()) {
            path = channel.getPath();
            for (Cell cell : this.cells) {
                if (!cell.path.equals(path)) continue;
                cell.channel = channel;
                this.format(cell);
                continue block4;
            }
        }
        ((Model)this.getModel()).fireTableDataChanged();
    }

    private void format(Cell cell) {
        if (cell.path == null) {
            return;
        }
        FormattedValue fv = MonitorFormat.DEFAULT.format(MonitorField.VALUE, cell.channel);
        if (cell.format != null) {
            fv.text = String.format(cell.format, fv.text);
        }
        cell.formattedValue = fv;
    }

    @Override
    public List<String> getOriginChannels() {
        return this.cells.stream().map(cell -> ((Cell)cell).path).collect(Collectors.toList());
    }

    @Override
    public List<String> getDisplayChannels() {
        return this.getOriginChannels();
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        return Collections.singletonList(originPath);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return Collections.singletonList("value");
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        this.maxSize.height = this.getPreferredSize().height;
        return this.maxSize;
    }

    public static void main(String ... args) {
        System.out.println(String.format("xxx%2sxxx%nyyy", "11"));
    }

    private class Model
    extends AbstractTableModel {
        private Model() {
        }

        @Override
        public int getRowCount() {
            return CellTableView.this.nRows;
        }

        @Override
        public int getColumnCount() {
            return CellTableView.this.nColumns;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return ((Cell)CellTableView.this.cells.get(rowIndex * CellTableView.this.nColumns + columnIndex)).formattedValue;
        }
    }

    public static class Cell {
        private final String path;
        private final String format;
        private AgentChannel channel;
        private FormattedValue formattedValue;

        public Cell(String path) {
            this(path, null);
        }

        public Cell(String path, String format) {
            this.path = path;
            this.format = format;
        }

        public Cell(FormattedValue formattedValue) {
            this.path = null;
            this.format = null;
            this.formattedValue = formattedValue;
        }
    }
}

