/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.messaging.LogMessageListener;

public class LogAggregator
implements LogMessageListener,
Spliterator<LogMessage> {
    long windowWidth = 20L;
    SortedSet<LogMessage> messages = new TreeSet<LogMessage>(logComparator);
    static LogComparator logComparator = new LogComparator();

    @Override
    public void onLogMessage(LogMessage msg) {
        this.push(msg);
    }

    synchronized void push(LogMessage msg) {
        this.messages.add(msg);
        this.notify();
    }

    synchronized LogMessage pull() {
        LogMessage m;
        while (this.messages.isEmpty() || (m = this.messages.first()).getTimeStamp() > System.currentTimeMillis() - this.windowWidth) {
            try {
                this.wait(this.messages.isEmpty() ? 100L : this.windowWidth);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.messages.remove(m);
        return m;
    }

    @Override
    public boolean tryAdvance(Consumer<? super LogMessage> action) {
        action.accept(this.pull());
        return true;
    }

    @Override
    public Spliterator<LogMessage> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 4373;
    }

    @Override
    public Comparator<? super LogMessage> getComparator() {
        return logComparator;
    }

    public Stream<LogMessage> stream() {
        return StreamSupport.stream(this, false);
    }

    static class LogComparator
    implements Comparator<LogMessage> {
        LogComparator() {
        }

        @Override
        public int compare(LogMessage m1, LogMessage m2) {
            int d = (int)(m1.getTimeStamp() - m2.getTimeStamp());
            if (d == 0) {
                d = m1.getFormattedDetails().compareTo(m2.getFormattedDetails());
            }
            return d;
        }
    }
}

