package org.lsst.ccs.gconsole.util.session;

import java.io.Serializable;

/**
 * Interface to be implemented by components whose state can be saved as a JavaBean.
 *
 * @author onoprien
 */
public interface Savable {
    
    /**
     * Restores this component to the state specified by the provided descriptor.
     * The default implementation does nothing.
     * 
     * @param descriptor JavaBean encapsulating the state.
     */
    default void restore(Serializable descriptor) {
    }
    
    /**
     * Returns JavaBean describing the current state of this component.
     * The default implementation returns {@code null}.
     * 
     * @return JavaBean encapsulating the state, or {@code null} if no state information needs to be saved.
     */
    default Serializable save() {
        return null;
    }
    
}
