package org.lsst.ccs.gconsole.util.session;

import java.io.Serializable;

/**
 * Adapter class intended to simplify implementing {@link Savable} interface.
 *
 * @author onoprien
 */
abstract public class AbstractSavable implements Savable {

// -- Fields : -----------------------------------------------------------------
    
    private Serializable descriptor;

// -- Life cycle : -------------------------------------------------------------
    /**
     * Default constructor.
     * The state descriptor instance is not set.
     */
    protected AbstractSavable() {
    }
    
    /**
     * Constructs an instance, setting the state descriptor instance.
     * @param descriptor JavaBean encapsulating the state.
     */
    protected AbstractSavable(Serializable descriptor) {
        this.descriptor = descriptor;
    }
    
// --Getters/setters : ---------------------------------------------------------

    /**
     * Returns a reference to the state descriptor maintained by this class.
     * @return JavaBean encapsulating the state, or {@code null} if the state descriptor has not been set.
     */
    public Serializable getDescriptor() {
        return descriptor;
    }

    /**
     * Sets the  maintained by this class.
     * @param descriptor JavaBean encapsulating the state.
     */
    public void setDescriptor(Serializable descriptor) {
        this.descriptor = descriptor;
    }
    
    
// -- Implement Savable : ------------------------------------------------------
    
    /**
     * Restores this component to the state specified by the provided descriptor.
     * The default implementation provided by this class forwards the call to {@link #setDescriptor}.
     * 
     * @param descriptor JavaBean encapsulating the state.
     */
    public void restore(Serializable descriptor) {
        setDescriptor(descriptor);
    }
    
    /**
     * Returns JavaBean describing the current state of this component.
     * The default implementation provided by this class forwards the call to {@link #getDescriptor}.
     * 
     * @return JavaBean encapsulating the state, or {@code null} if no state information needs to be saved.
     */
    public Serializable save() {
        return getDescriptor();
    }

}
