package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.*;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;

/**
 * {@link MonitorView} that displays data channels in a table.
 * The table is divided into collapsible sections corresponding to pages defined by the filter associated with this view.
 *
 * @author onoprien
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView",
               name="Sectioned Table View",
               path="Built-In/Sectioned Table",
               description="Monitoring view that displays data channels in a table. The table is divided into collapsible sections corresponding to pages defined by the filter associated with this view.")
public class SectionedTableView extends AbstractMonitorView2 {

// -- Fields : -----------------------------------------------------------------
    
    private final JScrollPane scrollPane = new JScrollPane();
    private SectionedTable table;

// -- Life cycle : -------------------------------------------------------------
    
    public SectionedTableView() {
        descriptor = new Descriptor();
        scrollPane.add(new MonitorDisplay.EMPTY());
    }

// -- Getters and setters : ----------------------------------------------------
    
    @Override
    public JComponent getPanel() {
        return scrollPane;
    }

// -- Updates from status aggregator : -----------------------------------------
    
    @Override
    protected void resetChannels() {
        List<String> attributes = getFilter() == null ? null : getFilter().getFields(false);
        List<MonitorField> fields = attributes == null ? MonitorTable.DEFAULT_FIELDS : new ArrayList<>(MonitorField.getDefaultFields(attributes));
        if (table != null) {
            save();
            table.destroy();
        }
        table = SectionedTable.getInstance(path2data.entrySet(), fields, getDescriptor().getTable());
        if (formatter != null) {
            table.setFormat(formatter);
        }
        scrollPane.setViewportView(table.getTable());
        scrollPane.revalidate();
    }
    
    
// -- Saving/restoring : -------------------------------------------------------
    
    static public class Descriptor extends AbstractMonitorView2.Descriptor {

        private SectionedTable.Descriptor table;

        public SectionedTable.Descriptor getTable() {
            return table;
        }

        public void setTable(SectionedTable.Descriptor table) {
            this.table = table;
        }
        
    }

    @Override
    public Descriptor save() {
        if (table != null) getDescriptor().setTable(table.save());
        return getDescriptor();
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor) descriptor;
        }
    }

    @Override
    protected Descriptor getDescriptor() {
        return (Descriptor) super.getDescriptor();
    }

}
