package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;

/**
 * Default {@link MonitorView}.
 * Displays pages in tabs and configuration view at the bottom.
 *
 * @author onoprien
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView",
               name="Default View",
               path="Built-In/Default",
               description="Default monitoring data view.")
public class DefaultView extends CompoundView {

// -- Fields : -----------------------------------------------------------------
    
    private final TabbedView tabbedView;
    private final ConfigView controlView;

// -- Life cycle : -------------------------------------------------------------
    
    public DefaultView() {
        super(new JPanel(new BorderLayout()));
        tabbedView = new TabbedView();
        addView(tabbedView, Mode.INDEPENDENT);
        getPanel().add(tabbedView.getPanel(), BorderLayout.CENTER);
        controlView = new ConfigView();
        addView(controlView, Mode.INDEPENDENT);
        getPanel().add(controlView.getPanel(), BorderLayout.SOUTH);
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        tabbedView.setFormatter(formatter);
    }

    @Override
    public MonitorFormat getFormater() {
        return tabbedView.getFormater();
    }
    


}
