package org.lsst.ccs.gconsole.agent.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;

/**
 * Filter that selects subsystem state channels.
 *
 * @author onoprien
 */
@ConsoleLookup(id = "org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
        name = "States",
        path = "Built-In/States",
        description = "Channels filter that selects subsystem state channels.<p>"
                + "<b>Optional parameters:</b>"
                + "<dl>"
                + "<dt>agents</dt><dd>Comma-separated list of subsystems accepted by this filter.</dd>"
                + "</dl>")
public class States extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final List<String> agents;

// -- Life cycle : -------------------------------------------------------------
    
    public States(String agents) {
        if (agents.trim().isEmpty()) {
            this.agents = null;
        } else if (agents.trim().equals("\"\"")) {
            this.agents = Collections.emptyList();
        } else {
            String[] ss = agents.split(",");
            this.agents = new ArrayList<>(ss.length);
            for (String s : ss) {
                this.agents.add(s.trim());
            }
        }
    }
    
// -- Implementing filter : ----------------------------------------------------

    @Override
    public List<String> getDisplayPath(String originPath) {
        String displayPath = originPath.replaceFirst("/state/", "/");
        return Collections.singletonList(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath.replaceFirst("/", "/state/");
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/state/");
    }

    @Override
    public List<String> getAgents() {
        return agents;
    }

    @Override
    public String getName() {
        return "States";
    }

}

