package org.lsst.ccs.gconsole.agent.filter;

import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.InstanceDialog;

/**
 * Adapter to simplify implementing {@link AgentChannelsFilter}.
 * Provides machinery for handling listeners.
 *
 * @author onoprien
 */
abstract public class AbstractChannelsFilter implements AgentChannelsFilter, InstanceDialog.Product {

// -- Fields : -----------------------------------------------------------------
    
    private final CopyOnWriteArrayList<AgentChannelsFilter.Listener> listeners = new CopyOnWriteArrayList<>();
    private InstanceDialog.Descriptor creator;

// -- Handling listeners : -----------------------------------------------------
    
    @Override
    public void addListener(AgentChannelsFilter.Listener listener) {
        listeners.addIfAbsent(listener);
    }
    
    @Override
    public void removeListener(AgentChannelsFilter.Listener listener) {
        listeners.remove(listener);
    }
    
    protected void notifyListeners() {
        AgentChannelsFilter.Event event = new AgentChannelsFilter.Event(AbstractChannelsFilter.this);
        listeners.forEach(listener -> listener.filterChanged(event));
    }
    
    
// -- Saving/restoring : -------------------------------------------------------

    @Override
    public InstanceDialog.Descriptor save() {
        return creator;
    }

    @Override
    public void setCreator(InstanceDialog.Descriptor dialogDescriptor) {
        creator = dialogDescriptor;
    }

}
