/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;

@Entity
@Immutable
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="org.lsst.ccs.localdb.statusdb.model.StateBundleDesc")
@NamedQueries(value={@NamedQuery(name="findStateBundleDesc", query="from StateBundleDesc sbd where sbd.hashMD5=:md5 ", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.readOnly", value="true")})})
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"hashMD5"})})
public class StateBundleDesc
implements Serializable {
    private static final long serialVersionUID = -8063672994380242038L;
    private long id;
    private Map<String, InnerStateDesc> componentStates = new HashMap<String, InnerStateDesc>();
    private byte[] hashMD5;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @MapKey(name="enumClassName")
    public Map<String, InnerStateDesc> getComponentStates() {
        return this.componentStates;
    }

    public void setComponentStates(Map<String, InnerStateDesc> componentStates) {
        this.componentStates = componentStates;
    }

    public static byte[] computeMD5(Map<String, InnerStateDesc> innerStates) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, InnerStateDesc> e2 : new TreeMap<String, InnerStateDesc>(innerStates).entrySet()) {
            String k = e2.getValue().getEnumClassName();
            String v = e2.getValue().getEnumValue();
            sb.append(k).append("/").append(v).append(":");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Column(columnDefinition="varbinary(100)", nullable=false, unique=true)
    public byte[] getHashMD5() {
        return this.hashMD5 == null ? null : Arrays.copyOf(this.hashMD5, this.hashMD5.length);
    }

    public void setHashMD5(byte[] hashMD5) {
        this.hashMD5 = hashMD5 == null ? null : Arrays.copyOf(hashMD5, hashMD5.length);
    }
}

