package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.base.Const;

/**
 *
 * @author emarin
 */
public class ArgInputPanel extends JPanel implements ListSelectionListener {
    
    private static interface ArgumentValueSelection {
        
        String getArgumentValue();
        
    }
    
    
    private JLabel[] argName;
    private ArgumentValueSelection[] argInput;
    private final JPanel formPane;
    private final JEditorPane commandDesc;
    
    public ArgInputPanel() {
        this.setLayout(new BorderLayout());
        commandDesc = new JEditorPane();
        commandDesc.setBackground(new Color(0xed, 0xec, 0xeb)); //TODO : color must match system colors
        commandDesc.setEditable(false);
        commandDesc.setContentType("text/html");
        commandDesc.setText("      ");
        
        add(commandDesc, BorderLayout.CENTER);
        formPane = new JPanel();
        formPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(Const.VSPACE, Const.HSPACE, Const.VSPACE, Const.HSPACE)));
    }
    
    public void clearForm() {
        formPane.removeAll();
        commandDesc.setText("       ");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            add(formPane, BorderLayout.SOUTH);
        } else {
            this.remove(formPane);
        }
    }
    
    public final void fillFormPane(DictionaryCommand cmd) {
        clearForm();
        final int nbArgs = cmd.getArguments().length;
        formPane.setLayout(new GridLayout(nbArgs, 2));
        argName = new JLabel[nbArgs];
        argInput = new ArgumentValueSelection[nbArgs];
        // createButton();
        for (int i = 0; i < nbArgs; i++) {
            DictionaryArgument da = cmd.getArguments()[i];
            
            argName[i] = new JLabel(da.getName());
            formPane.add(argName[i]);            
            if(da.getAllowedValues().isEmpty()) {
                HintTextField htf = new HintTextField(cmd.getArguments()[i].getSimpleType());
                argInput[i] = () -> {
                    return htf.getText();
                };
                formPane.add(htf);
            } else {
                JComboBox<String> allowedValuesBox = new JComboBox<>(da.getAllowedValues().toArray(new String[0]));
                argInput[i] = () -> {
                    return allowedValuesBox.getSelectedItem().toString();
                };
                formPane.add(allowedValuesBox);
            }
        }
        
        String cmdDescString = cmd.getDescription() + "<br>";
        DictionaryArgument[] argTable = cmd.getArguments();
        String cmdArguments = "";
        for (int i = 0; i < argTable.length; i++) {
            cmdArguments = cmdArguments + " <b>" + argTable[i].getSimpleType() + "</b>"
                    + " " + argTable[i].getName()
                    + " : " + argTable[i].getDescription()
                    + "<br>";
        }
        
        commandDesc.setText("<html><h3>" + cmdDescString + "</h3><p>" + cmdArguments + "</p>");
        
        setEnabled(isEnabled());
        repaint();
        validate();
    }
    
    public String getFormattedArgumentValues() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < argInput.length; i++) {
            res.append(argInput[i].getArgumentValue()).append(" ");
        }
        return res.toString();
    }
    
    @Override
    public void valueChanged(ListSelectionEvent lse) {
        DictionaryCommand cmd = ((JList<DictionaryCommand>)lse.getSource()).getSelectedValue();
        clearForm();
        if (cmd != null) {
            fillFormPane(cmd);
        }
    }
}
