package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.PlotRegionDropHandler;

/**
 * Drop handler that supports drag-and-dropping trending channel nodes into plotter regions.
 * 
 * Note that with the current implementation of {@code org.freehep.jas.plugin.plotter.DefaultRegion},
 * {@code drop(DropTargetDropEvent)} is the only method of this class that ever gets called,
 * and the user action is always {@code ACTION_LINK}. This makes it impossible to let the user choose
 * what happens on every particular drop - the operation is set through preferences.
 *
 * @author onoprien
 */
public class ChannelDropHandler implements PlotRegionDropHandler {

// -- Private parts : ----------------------------------------------------------
    
    private final LsstTrendingPlugin plugin;
    private PlotRegion region;

// -- Construction and initialization : ----------------------------------------

    public ChannelDropHandler(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
    }

// -- Implementing PlotRegionDropHandler : -------------------------------------
    
    @Override
    public void setPlotRegion(PlotRegion region) {
      this.region = region;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (region == null) return;
        Transferable trans = dtde.getTransferable();
        TrendingChannel channel = null;
        for (DataFlavor flavor : trans.getTransferDataFlavors()) {
            Class k = flavor.getRepresentationClass();
            if (TrendingChannel.class.isAssignableFrom(k)) {
                try {
                    channel = (TrendingChannel) trans.getTransferData(flavor);
                    break;
                } catch (IOException|UnsupportedFlavorException x) {
                }
            }
        }
        if (channel != null) {
            if (plugin.getPreferences().getDnd() == 1) {
                plugin.plot(channel, null, region, TrendPlotter.Option.OVERLAY);
            } else {
                plugin.plot(channel, null, region);
            }
        } else {
            dtde.rejectDrop();
        }
        dtde.dropComplete(true);
    }

}
