package org.lsst.ccs.gconsole.plugins.demo.monitor.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;

/**
 * 
 *
 * @author onoprien
 */
//@Plugin(name = "Image View Demo Plugin",
//        id="image-view-demo",
//        description = "Demo of image-based views of monitoring data.")
public class ImageViewPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private final OptionalPage opt1 = new OptPage1();

// -- Life cycle : -------------------------------------------------------------
    
    @Override
    public void initialize() {
        Console.getConsole().addOptionalPage(opt1);
    }
    
// -- Optional page descriptors : ----------------------------------------------
    
    static class OptPage1 implements OptionalPage {
        
        private ImageView imageView;

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPath() {
            return "Demo/Image View";
        }

        @Override
        public String getPage(AgentInfo agent) {
            return agent.getName();
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            System.out.println("Opening page for "+ agent.getName());
        
            try {
                BufferedImage back = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/grid.png"));
                imageView = new ImageView("ImageView test", back, .5, 2.);
                ImageView.Item item;

                CellTableView.Cell c0 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel0");
                CellTableView.Cell c1 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1");
                CellTableView.Cell c2 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel2");
                CellTableView.Cell c3 = new CellTableView.Cell("demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel3");
                CellTableView t = new CellTableView(2, 2, c0, c1, c2, c3);
                item = new ImageView.Item(t);
                item.setPosition(40, 399);
                item.setAlignment(JComponent.LEFT_ALIGNMENT, JComponent.TOP_ALIGNMENT);
                item.setMaxSize(471, 246);
//            item.setMinSize(108, 105);
                item.setMinWidth(108);
                imageView.add(item);

                BufferedImage demo = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/demo.png"));
                item = new ImageView.Item(demo);
                item.setPosition(0, 0);
                item.setAlignment(JComponent.LEFT_ALIGNMENT, JComponent.TOP_ALIGNMENT);
                item.setSize(1., 1.);
                item.setLayer(2);
                imageView.add(item);

                BufferedImage cir = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/plugins/demo/monitor/image/circle.png"));
                item = new ImageView.Item(cir);
                item.setPosition(40, 399);
                item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
                item.setSize(25, 25);
                item.setLayer(3);
                imageView.add(item);

                return imageView.getPanel();
                
            } catch (Exception e) {
                e.printStackTrace();
                return new JLabel(e.toString());
            }

        }

        @Override
        public void opened(String page) {
            System.out.println("Opened "+ page);
            imageView.install();
//            imageView.getPanel().invalidate();
//            imageView.getPanel().validate();
//            imageView.getPanel().revalidate();
//            imageView.getPanel().repaint();
        }

        @Override
        public void closed(String page) {
            System.out.println("Closed "+ page);
        }

        @Override
        public boolean agentDisconnected(AgentInfo agent) {
            System.out.println("Disconnection: "+ agent.getName());
            return false;
        }
        
    }
    
}
