package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Demo filter that only displays channels with values out of range.
 *
 * @author onoprien
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Out Of Range Filter",
               path="Demo/OutOfRange",
               description="Filter that selects out-of-range channels.")
public class FilterOutOfRange extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------
    
// -- Filtering : --------------------------------------------------------------

    @Override
    public List<String> getDisplayPath(AgentChannel channel) {
        try {
            double value = (Double) channel.get();
            Double low = (Double) channel.get(MonitorField.LOW_ALARM.getKey());
            if (low != null && low > value) return Collections.singletonList(channel.getPath());
            Double high = (Double) channel.get(MonitorField.HIGH_ALARM.getKey());
            if (high != null && high < value) return Collections.singletonList(channel.getPath());
        } catch (ClassCastException x) {
        }
        return Collections.emptyList();
    }

}
