/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;

public class CellView
extends JLabel
implements MonitorView,
AgentChannelsFilter {
    private final String path;
    private AgentChannel channel;
    private int maxLength;
    private Dimension size;
    private Dimension maxSize;

    public CellView(String content) {
        this.path = content;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.setText("<html>12345<br>67890");
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return this;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
    }

    @Override
    public MonitorView.Descriptor save() {
        return MonitorView.super.save();
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        MonitorView.super.restore(descriptor);
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void configure(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> {
            this.channel = null;
            this.format();
        });
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.update(event));
    }

    private void update(AgentStatusEvent event) {
        if (this.channel == null) {
            List<AgentChannel> cc = event.getAddedChannels();
            if (!cc.isEmpty()) {
                this.channel = cc.get(0);
                this.format();
            }
        } else if (!event.getRemovedChannels().isEmpty()) {
            this.channel = null;
            this.format();
        } else if (!event.getStatusChanges().isEmpty()) {
            this.format();
        }
    }

    private void format() {
        FormattedValue fv = MonitorFormat.DEFAULT.format(MonitorField.VALUE, this.channel);
        this.setBackground(fv.getBgColor());
        this.setForeground(fv.getFgColor());
        this.setHorizontalAlignment(fv.getHorizontalAlignment());
        this.setToolTipText(fv.getToolTip());
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList(this.path);
    }

    @Override
    public List<String> getDisplayChannels() {
        return Collections.singletonList(this.path);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        return Collections.singletonList(this.path);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return Collections.singletonList("value");
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.maxSize;
    }
}

