/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.plugins.dictionary.AgentDefaultTableModel;

public class AgentTable
extends JTable
implements ItemListener {
    private static final Object[] columnNames = new Object[]{"agentName"};
    private AgentDefaultTableModel tableModel = new AgentDefaultTableModel(columnNames, 0);
    private TableRowSorter<AgentDefaultTableModel> sorter = new TableRowSorter<AgentDefaultTableModel>(this.tableModel);
    private boolean[] checkSelected = new boolean[AgentInfo.AgentType.values().length];

    public AgentTable() {
        this.setModel(this.tableModel);
        this.setRowSorter(this.sorter);
        this.getColumn("agentName").setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null) {
                    this.setText(((AgentInfo)value).getName());
                    this.setToolTipText(((AgentInfo)value).getName());
                }
                return this;
            }
        });
        this.getColumn("agentName").setPreferredWidth(200);
        this.setRowHeight(27);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setTableHeader(null);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox checkBox = (JCheckBox)e.getSource();
        String name = checkBox.getName();
        AgentInfo.AgentType type = AgentInfo.AgentType.valueOf((String)name);
        this.checkSelected[type.ordinal()] = checkBox.isSelected();
        ArrayList<2> filterList = new ArrayList<2>();
        for (final AgentInfo.AgentType agentType : AgentInfo.AgentType.values()) {
            if (!this.checkSelected[agentType.ordinal()]) continue;
            filterList.add(new RowFilter<AgentDefaultTableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends AgentDefaultTableModel, ? extends Integer> entry) {
                    AgentInfo agent = (AgentInfo)entry.getModel().getValueAt(entry.getIdentifier(), 0);
                    return agent.getType().equals((Object)agentType);
                }
            });
        }
        RowFilter filter = RowFilter.orFilter(filterList);
        this.sorter.setRowFilter(filter);
    }
}

