/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.BaseState;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;

@Entity
@Immutable
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="org.lsst.ccs.localdb.statusdb.model.AgentState")
@NamedQueries(value={@NamedQuery(name="findAgentState", query="from AgentState ast where ast.agentDesc=:agentDesc and ast.baseState.id=:baseStateId ", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
@Table(indexes={@Index(columnList="agentName"), @Index(columnList="baseStateId")})
public class AgentState
implements Serializable {
    private static final long serialVersionUID = -8367786148299296222L;
    private long id;
    private AgentDesc agentDesc;
    private BaseState baseState;
    private Map<String, InnerStateDesc> innerStates = new HashMap<String, InnerStateDesc>();
    private Map<String, StateBundleDesc> componentStates = new HashMap<String, StateBundleDesc>();

    protected AgentState() {
    }

    public AgentState(AgentDesc ad) {
        this.agentDesc = ad;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="agentName")
    public AgentDesc getAgentDesc() {
        return this.agentDesc;
    }

    public void setAgentDesc(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    @ManyToOne(optional=false)
    public BaseState getBaseState() {
        return this.baseState;
    }

    public void setBaseState(BaseState baseState) {
        this.baseState = baseState;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @MapKey(name="enumClassName")
    public Map<String, InnerStateDesc> getInnerStates() {
        return this.innerStates;
    }

    public void setInnerStates(Map<String, InnerStateDesc> innerStates) {
        this.innerStates = innerStates;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    public Map<String, StateBundleDesc> getComponentStates() {
        return this.componentStates;
    }

    public void setComponentStates(Map<String, StateBundleDesc> componentStates) {
        this.componentStates = componentStates;
    }

    public Map<String, Map<String, String>> asFlatStatesMap(List<String> components) {
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>();
        if (components == null || components.isEmpty() || components.contains("")) {
            HashMap<String, String> subStates = new HashMap<String, String>();
            subStates.put("org.lsst.ccs.bus.states.AlertState", this.baseState.getAlertState());
            subStates.put("org.lsst.ccs.bus.states.PhaseState", this.baseState.getPhaseState());
            subStates.put("org.lsst.ccs.bus.states.CommandState", this.baseState.getCommandState());
            subStates.put("org.lsst.ccs.bus.states.OperationalState", this.baseState.getOperationalState());
            subStates.put("org.lsst.ccs.bus.states.ConfigState", this.baseState.getConfigState());
            if (!this.innerStates.isEmpty()) {
                for (InnerStateDesc innerStateDesc : this.innerStates.values()) {
                    subStates.put(innerStateDesc.getEnumClassName(), innerStateDesc.getEnumValue());
                }
            }
            res.put("", subStates);
            if (components != null && components.size() == 1) {
                return res;
            }
            for (Map.Entry entry : this.componentStates.entrySet()) {
                HashMap<String, String> flatMap = (HashMap<String, String>)res.get(entry.getKey());
                if (flatMap == null) {
                    flatMap = new HashMap<String, String>();
                    res.put((String)entry.getKey(), (Map<String, String>)flatMap);
                }
                for (InnerStateDesc isd : ((StateBundleDesc)entry.getValue()).getComponentStates().values()) {
                    flatMap.put(isd.getEnumClassName(), isd.getEnumValue());
                }
            }
            return res;
        }
        for (String component : components) {
            StateBundleDesc stateBundleDesc = this.componentStates.get(component);
            if (stateBundleDesc == null) continue;
            HashMap<String, String> flatMap = new HashMap<String, String>();
            for (InnerStateDesc isd : stateBundleDesc.getComponentStates().values()) {
                flatMap.put(isd.getEnumClassName(), isd.getEnumValue());
            }
            res.put(component, flatMap);
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.agentDesc.getAgentName());
        sb.append(":").append(this.baseState.toString()).append(",");
        for (InnerStateDesc isd : this.innerStates.values()) {
            sb.append(isd.toString()).append(",");
        }
        return sb.toString();
    }
}

