/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.monitor.Channel;

class DataProviderInfoImpl
implements DataProviderInfo {
    private static final long serialVersionUID = -905853368743117573L;
    private final String path;
    private final String key;
    private final Map<DataProviderInfo.Attribute, String> attributes = new HashMap<DataProviderInfo.Attribute, String>();

    DataProviderInfoImpl(String path, String key) {
        this.path = path;
        this.key = key;
    }

    void addAttribute(DataProviderInfo.Attribute attribute, String value) {
        if (value != null && !value.isEmpty()) {
            this.attributes.put(attribute, value);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getAttributeValue(DataProviderInfo.Attribute attr) {
        return this.attributes.get(attr);
    }

    public String getKey() {
        return this.key;
    }

    public DataProviderInfo.Attribute[] getAttributes() {
        return this.attributes.keySet().toArray(new DataProviderInfo.Attribute[0]);
    }

    public String toString() {
        return this.path + "(" + this.key + ")";
    }

    void addAttributesForObject(Object obj) {
        if (obj instanceof Channel) {
            Channel channel = (Channel)obj;
            this.addAttribute(DataProviderInfo.Attribute.UNITS, channel.getUnits());
            this.addAttribute(DataProviderInfo.Attribute.FORMAT, channel.getFormat());
            this.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, channel.getDescription());
            this.addAttribute(DataProviderInfo.Attribute.PAGE, String.valueOf(channel.getPageId()));
            this.addAttribute(DataProviderInfo.Attribute.ALARMHI, String.valueOf(channel.getAlarmNameHi()));
            this.addAttribute(DataProviderInfo.Attribute.ALARMLO, String.valueOf(channel.getAlarmNameLo()));
        }
    }
}

