package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * Demo filter that displays all monitoring channels from all subsystems, using subsystem name as a page name.
 * Monitoring channels are defined as such in the groovy description.
 *
 * @author onoprien
 */
@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
               name="Monitored",
               path="Demo/Monitored",
               description="Channels filter that selects monitored channels.")
public class FilterMonitored extends AbstractChannelsFilter {

    @Override
    public List<String> getDisplayPath(String originPath) {
        return Collections.singletonList(originPath.replaceFirst("/", "//"));
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath.replaceFirst("//", "/");
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList(MonitorField.ID_KEY);
    }

}
