/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.io.PrintWriter;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.utilities.logging.Logger;

public class MonitorGui
implements CommandSender,
StatusMessageListener,
AgentPresenceListener {
    protected Panel panel;
    private PrintWriter out = new PrintWriter(System.out, true);
    private final Map<String, Subsys> subsysMap = new HashMap<String, Subsys>();
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.monitor");
    private ConcurrentMessagingUtils cmu;
    private AgentPresenceManager apm;

    public void addSubsys(String name, int id, String initCmd) {
        this.subsysMap.put(name, new Subsys(name, id, initCmd));
    }

    public void initGui() {
        AgentMessagingLayer aml = Agent.getEnvironmentMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(aml);
        aml.addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
        this.apm = aml.getAgentPresenceManager();
        this.apm.addAgentPresenceListener((AgentPresenceListener)this);
    }

    public JComponent getGuiLayout() {
        return this.panel;
    }

    public Logger getLogger() {
        return this.log;
    }

    public void resetGui() {
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void startGui(String name, String title) {
        new Agent(name, AgentInfo.AgentType.CONSOLE).startAgent();
        this.initGui();
        JFrame f = new JFrame(title);
        f.setContentPane(this.getGuiLayout());
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }

    public void onStatusMessage(StatusMessage s) {
        Subsys ss = this.subsysMap.get(s.getOriginAgentInfo().getName());
        if (ss == null) {
            return;
        }
        if (s instanceof StatusSubsystemData) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)s;
                this.panel.handleStatusData(ss.name, ss.id, sd.getTimeStamp(), sd.getDataKey(), sd.getSubsystemData());
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }
    }

    public void connecting(AgentInfo agent) {
        Subsys ss = this.subsysMap.get(agent.getName());
        if (ss == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> this.enable(ss));
    }

    public void disconnecting(AgentInfo agent) {
        SwingUtilities.invokeLater(() -> this.disable(this.subsysMap.get(agent.getName())));
    }

    @Override
    public Object sendCommand(String dest, String target, String cmnd, Object ... args) {
        try {
            return this.sendCommandRaw(dest, target, cmnd, args);
        }
        catch (Exception e) {
            this.log.error((Object)"Command error: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public Object sendCommandRaw(String dest, String target, String cmnd, Object ... args) throws Exception {
        String dst = dest + (target == null ? "" : "/" + target);
        CommandRequest cmd = new CommandRequest(dst, cmnd, args);
        return this.cmu.sendSynchronousCommand(cmd, Duration.ofMillis(5000L));
    }

    private void enable(Subsys ss) {
        if (ss.initCmd == null || ss.initCmd.isEmpty()) {
            ss.enabled = true;
            this.panel.enableSystem(ss.name, ss.id);
        } else {
            Object resp = this.sendCommand(ss.name, null, ss.initCmd, new Object[0]);
            if (resp != null) {
                ss.enabled = true;
                this.panel.updatePanel(ss.name, ss.id, resp);
            }
        }
    }

    private void disable(Subsys ss) {
        if (ss == null || !ss.enabled) {
            return;
        }
        ss.enabled = false;
        this.panel.disableSystem(ss.name, ss.id);
    }

    public static class Panel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        protected void enableSystem(String name, int id) {
        }

        protected void disableSystem(String name, int id) {
        }

        protected void updatePanel(String name, int id, Object d) {
        }

        protected void handleStatusData(String name, int id, long time, String key, Object d) {
        }

        protected void handleStatusMessage(String name, int id, StatusMessage s) {
        }
    }

    static class Subsys {
        final String name;
        final String initCmd;
        final int id;
        boolean enabled;

        Subsys(String name, int id, String initCmd) {
            this.name = name;
            this.id = id;
            this.initCmd = initCmd;
            this.enabled = false;
        }
    }
}

