package org.lsst.ccs.gconsole.agent.filter;

import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * 
 *
 * @author onoprien
 */
@ConsoleLookup(id = "org.lsst.ccs.gconsole.agent.AgentChannelsFilter",
        name = "Monitored channels",
        path = "Built-In/Monitored",
        description = "Channels filter that selects monitoring channels as specified in the Groovy description. <p>"
                + "<b>Optional parameters:</b>"
                + "<dl>"
                + "<dt>agents</dt><dd>Comma-separated list of subsystems accepted by this filter.</dd>"
                + "<dt>delimeter</dt><dd>Character in the original channel path that should be replaced by a slash (and therefore used as a path delimeter).</dd>"
                + "<dt>separatePagesForAgents</dt><dd>If true, the subsystem name is used as a page name.</dd>"
                + "</dl>")
public class MonitorOnly extends GenericFilter {

    public MonitorOnly(String agents, String delimeter, boolean separatePagesForAgents) {
        super("Monitored channels", agents, MonitorField.ID_KEY, delimeter, separatePagesForAgents);
    }

}

