/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.startup.HasCommandLineOptions;

public class SubsystemBoot {
    static String[] descriptionNames;
    static String[] configurationFileNames;
    static String[] subsystemAliases;
    static boolean printHelp;
    static Options commandLineOptions;

    public static void main(String[] args) throws Exception {
        String[] argsToBeProcessed = SubsystemBoot.parseArgsCLI(args);
        if (printHelp) {
            SubsystemBoot.usageCLI(commandLineOptions);
        }
        if (descriptionNames != null) {
            int numberOfAgents = descriptionNames.length;
            if (numberOfAgents == 0) {
                throw new IllegalArgumentException("Something went wrong. There must be at least one description: " + numberOfAgents);
            }
            if (configurationFileNames != null && configurationFileNames.length != numberOfAgents) {
                throw new IllegalArgumentException("Wrong number of arguments passed to option configuration: " + configurationFileNames.length + ". It must be either empty or the same as the number of descriptions: " + numberOfAgents);
            }
            if (subsystemAliases != null && subsystemAliases.length != numberOfAgents) {
                throw new IllegalArgumentException("Wrong number of arguments passed to option alias: " + subsystemAliases.length + ". It must be either empty or the same as the number of descriptions: " + numberOfAgents);
            }
            for (int i = 0; i < numberOfAgents; ++i) {
                String descriptionName = descriptionNames[i];
                String configurationFileName = configurationFileNames != null ? configurationFileNames[i] : null;
                try {
                    ComponentLookup lookup = BootUtils.buildComponentLookupFromDescription(descriptionName, configurationFileName);
                    ComponentNode topNode = lookup.getTopComponentNode();
                    Object topObj = topNode.getComponent();
                    if (printHelp) {
                        if (!(topObj instanceof HasCommandLineOptions)) continue;
                        ((HasCommandLineOptions)topObj).printHelp();
                        continue;
                    }
                    if (topObj instanceof HasCommandLineOptions) {
                        try {
                            ((HasCommandLineOptions)topObj).processCommandLineOptions(argsToBeProcessed);
                        }
                        catch (ParseException e) {
                            ((HasCommandLineOptions)topObj).printHelp();
                            throw new RuntimeException("Failed to start " + descriptionName, e);
                        }
                    }
                    String agentAlias = subsystemAliases != null ? (subsystemAliases[i].isEmpty() ? null : subsystemAliases[i]) : null;
                    Subsystem a = BootUtils.getSubsystemFromLookup(lookup, agentAlias);
                    ((Agent)a).startAgent();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to start subsystem with description: " + descriptionName, e);
                }
            }
        } else {
            throw new IllegalArgumentException("no description has been specified");
        }
    }

    static String[] parseArgsCLI(String[] args) {
        commandLineOptions = new Options();
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        commandLineOptions.addOption("d", "description", true, "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        commandLineOptions.addOption("c", "configuration", true, "Name of Configuration properties file.");
        commandLineOptions.getOption("configuration").setArgName("CONFIGURATION_FILE");
        commandLineOptions.addOption("a", "alias", true, "Name of subsystem on the buses.");
        commandLineOptions.getOption("alias").setArgName("SUBSYSTEM_NAME");
        commandLineOptions.getOption("description").setArgs(-2);
        commandLineOptions.getOption("configuration").setArgs(-2);
        commandLineOptions.getOption("alias").setArgs(-2);
        BasicParser parser = new BasicParser();
        List[] splitArgs = BootstrapResourceUtils.separateArgumentsForOptions((String[])args, (Options)commandLineOptions);
        try {
            String[] newArgs = splitArgs[0].toArray(new String[splitArgs[0].size()]);
            CommandLine line = parser.parse(commandLineOptions, newArgs, true);
            printHelp = line.hasOption("help");
            descriptionNames = line.getOptionValues("description");
            configurationFileNames = line.getOptionValues("configuration");
            subsystemAliases = line.getOptionValues("alias");
        }
        catch (ParseException e) {
            SubsystemBoot.usageCLI(commandLineOptions);
            System.exit(0);
        }
        String[] leftOverArgs = splitArgs[1].toArray(new String[splitArgs[1].size()]);
        return leftOverArgs;
    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "SubsystemBoot", "", options, "", true);
    }

    static {
        subsystemAliases = null;
        printHelp = false;
    }
}

