package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.*;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;

/**
 * {@link MonitorView} that displays data channels in a single table with the name column rendered as a tree.
 *
 * @author onoprien
 */
//@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView",
//               name="Tree Table View",
//               path="Built-In/Tree Table",
//               description="Monitoring view that displays its data in a table with collapsible rows.")
public class TreeTableView extends AbstractMonitorView {

// -- Fields : -----------------------------------------------------------------
    
    private final JScrollPane scrollPane = new JScrollPane();

// -- Life cycle : -------------------------------------------------------------
    
    public TreeTableView() {
        scrollPane.add(new MonitorDisplay.EMPTY());
    }

// -- Getters and setters : ----------------------------------------------------
    
    @Override
    public JComponent getPanel() {
        return scrollPane;
    }

// -- Updates from status aggregator : -----------------------------------------
    
    @Override
    protected void resetChannels() {
        AgentChannelsFilter filter = getFilter();
        List<String> attributes = filter == null ? null : filter.getFields(false);
        List<MonitorField> fields = attributes == null ? MonitorTable.defaultFields : new ArrayList<>(MonitorTable.translateAttributesToFields(attributes));
        TreeTable table = new TreeTable(path2data, fields);
        scrollPane.setViewportView(table.getTable());
        scrollPane.revalidate();
    }


}
