/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentPresenceManager
implements StatusMessageListener {
    private final Object agentsLock = new Object();
    final CopyOnWriteArrayList<AgentPresenceListener> listAPL = new CopyOnWriteArrayList();
    private final Map<AgentInfo, TimeoutTask> mapAgents = new HashMap<AgentInfo, TimeoutTask>();
    private final Map<String, AgentInfo> mapAgentsPDI = new HashMap<String, AgentInfo>();
    private static final int SUSPICION_LENGTH = 10;
    private final Timer timer;
    private final boolean providesDisconnectionInformation;
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.messaging.agentpresencemanager");
    private final ReentrantLock agentWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, String> agentWaitList;

    public AgentPresenceManager(boolean providesDisconnectionInformation) {
        this.providesDisconnectionInformation = providesDisconnectionInformation;
        this.timer = providesDisconnectionInformation ? null : new Timer(true);
    }

    @Override
    public void onStatusMessage(StatusMessage s) {
        AgentInfo a = s.getOriginAgentInfo();
        if (a == null) {
            return;
        }
        if (this.providesDisconnectionInformation) {
            this.addAgent(a);
        } else {
            int broadCastPeriod = -1;
            if (s instanceof StatusHeartBeat) {
                StatusHeartBeat hb = (StatusHeartBeat)s;
                broadCastPeriod = hb.getStatusBroadcastPeriod();
            }
            if (s.getState().isInState(PhaseState.OFF_LINE)) {
                log.debug((Object)"remove agent on status end");
                this.removeAgent(a);
            } else {
                this.updateAgent(a, broadCastPeriod);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgent(AgentInfo a, int broadcastPeriod) {
        Object object = this.agentsLock;
        synchronized (object) {
            TimeoutTask task = this.mapAgents.get(a);
            if (task != null) {
                task.cancel();
                if (broadcastPeriod == -1) {
                    broadcastPeriod = task.getBroadcastPeriod();
                }
                task = new TimeoutTask(a, broadcastPeriod);
                this.addAgent(a, task, false);
            } else {
                if (broadcastPeriod == -1) {
                    broadcastPeriod = 10;
                }
                task = new TimeoutTask(a, broadcastPeriod);
                this.addAgent(a, task, true);
            }
            log.debug((Object)("resetting timer for agent " + a.getName() + " to " + broadcastPeriod));
            this.timer.schedule((TimerTask)task, 10000 * broadcastPeriod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAgent(AgentInfo agent) {
        Object object = this.agentsLock;
        synchronized (object) {
            log.debug((Object)("removing agent " + agent.getName()));
            TimeoutTask t = this.mapAgents.remove(agent);
            if (t != null) {
                t.cancel();
                this.disconnecting(agent);
            } else {
                log.debug((Object)"removing agent with null timer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAgent(String agentName) {
        log.debug((Object)("removing agent " + agentName));
        Object object = this.agentsLock;
        synchronized (object) {
            AgentInfo agent = this.mapAgentsPDI.remove(agentName);
            if (agent != null) {
                this.disconnecting(agent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAgent(AgentInfo agent, TimeoutTask task, boolean isNewAgent) {
        Object object = this.agentsLock;
        synchronized (object) {
            this.mapAgents.put(agent, task);
            if (isNewAgent) {
                this.connecting(agent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAgent(AgentInfo a) {
        Object object = this.agentsLock;
        synchronized (object) {
            if (this.mapAgentsPDI.get(a.getName()) == null) {
                log.fine((Object)("adding " + a + " to the apm agent list"));
                this.mapAgentsPDI.put(a.getName(), a);
                this.connecting(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AgentInfo> listConnectedAgents() {
        Object object = this.agentsLock;
        synchronized (object) {
            if (this.providesDisconnectionInformation) {
                ArrayList<AgentInfo> list = new ArrayList<AgentInfo>();
                Set<Map.Entry<String, AgentInfo>> set = this.mapAgentsPDI.entrySet();
                for (Map.Entry<String, AgentInfo> e : set) {
                    list.add(e.getValue());
                }
                return list;
            }
            return new ArrayList<AgentInfo>(this.mapAgents.keySet());
        }
    }

    private void connecting(AgentInfo agent) {
        this.agentWaitNotify(agent.getName());
        for (AgentPresenceListener l : this.listAPL) {
            l.connecting(agent);
        }
    }

    private void disconnecting(AgentInfo agent) {
        for (AgentPresenceListener l : this.listAPL) {
            l.disconnecting(agent);
        }
    }

    void disconnecting(String agentName) {
        if (this.providesDisconnectionInformation) {
            this.removeAgent(agentName);
        }
    }

    public void anormalEvent(Exception exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentPresenceListener(AgentPresenceListener l) {
        Object object = this.agentsLock;
        synchronized (object) {
            for (AgentInfo a : this.listConnectedAgents()) {
                l.connecting(a);
            }
            this.listAPL.add(l);
        }
    }

    public void removeAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.remove(l);
    }

    public boolean agentExists(String agentName) {
        for (AgentInfo a : this.listConnectedAgents()) {
            if (!a.getName().equals(agentName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForAgent(String name, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.agentWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (this.agentExists(name)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.agentWaitLock.newCondition();
            if (this.agentWaitList == null) {
                this.agentWaitList = new LinkedHashMap(4);
            }
            this.agentWaitList.put(condition, name);
            while (this.agentWaitList != null && this.agentWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.agentWaitLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentWaitNotify(String name) {
        if (this.agentWaitList != null) {
            try {
                this.agentWaitLock.lockInterruptibly();
                if (this.agentWaitList == null) {
                    return;
                }
                Iterator<Map.Entry<Condition, String>> it = this.agentWaitList.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Condition, String> entry = it.next();
                    String agentWaitName = entry.getValue();
                    if (!name.equals(agentWaitName)) continue;
                    entry.getKey().signal();
                    it.remove();
                }
                if (this.agentWaitList.isEmpty()) {
                    this.agentWaitList = null;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.agentWaitLock.unlock();
            }
        }
    }

    class TimeoutTask
    extends TimerTask {
        private final AgentInfo agent;
        private final int broadcastPeriod;

        TimeoutTask(AgentInfo agent, int broadcastPeriod) {
            this.agent = agent;
            this.broadcastPeriod = broadcastPeriod;
        }

        int getBroadcastPeriod() {
            return this.broadcastPeriod;
        }

        @Override
        public void run() {
            AgentPresenceManager.this.removeAgent(this.agent);
        }
    }
}

