/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.py4j;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import py4j.GatewayServer;

public class Py4JServer
extends BusMaster {
    private final List<Py4jGatewayServer> gateways = new ArrayList<Py4jGatewayServer>();

    public Py4JServer() {
        super("py4j-server", AgentInfo.AgentType.SERVICE);
    }

    @Override
    public void doStart() {
        try {
            if (this.gateways.isEmpty()) {
                this.startGateway();
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doShutdown() {
        for (Py4jGatewayServer gw : this.gateways) {
            gw.stopServer();
        }
        super.doShutdown();
    }

    @Command
    public void startGateway() throws UnknownHostException {
        this.startGateway("default-localhost", 25333, "127.0.0.1", 25334);
    }

    @Command(description="starts a gateway")
    public void startGateway(@Argument(description="the name of this gateway") String name, @Argument(description="the listening port") int port, @Argument(description="the python client's host address") String pythonAddress, @Argument(description="the python client's callback port") int callbackPort) throws UnknownHostException {
        Py4jGatewayServer gateway = new Py4jGatewayServer(name, port, pythonAddress, callbackPort);
        gateway.startServer();
        this.gateways.add(gateway);
    }

    @Command
    public String listGateways() {
        StringBuilder sb = new StringBuilder();
        if (this.gateways.size() == 0) {
            sb.append("No gateways are currently available");
        } else {
            for (Py4jGatewayServer gw : this.gateways) {
                sb.append(gw).append("\n");
            }
        }
        return sb.toString();
    }

    private class Py4jGatewayServer {
        private final String name;
        private final String pythonAddress;
        private final int port;
        private final int callbackPort;
        private final GatewayServer server;

        Py4jGatewayServer() throws UnknownHostException {
            this("default-localhost", 25333, "127.0.0.1", 25334);
        }

        Py4jGatewayServer(String name, int port, String pythonAddress, int callbackPort) {
            this.name = name;
            this.port = port;
            this.pythonAddress = pythonAddress;
            this.callbackPort = callbackPort;
            try {
                InetAddress address = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName()).getInterfaceAddresses().get(0).getAddress();
                this.server = new GatewayServer((Object)this, port, 25334, address, InetAddress.getByName(pythonAddress), 0, 0, null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getPythonAddress() {
            return this.pythonAddress;
        }

        public int getPort() {
            return this.port;
        }

        private void startServer() {
            this.server.start();
        }

        private void stopServer() {
            this.server.shutdown();
        }

        public String toString() {
            try {
                return this.getName() + " Java(" + InetAddress.getLocalHost().getHostName() + ":" + this.getPort() + ") -> Python(" + this.getPythonAddress() + ")";
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }

        public void initializeScriptingEnvironment() throws UnknownHostException {
            this.server.resetCallbackClient(InetAddress.getByName(this.pythonAddress), this.callbackPort);
            CCS.initializeScriptingEnvironment();
        }

        public void shutdownScriptingEnvironment() throws Exception {
            CCS.shutdownScriptingEnvironment();
        }

        public ScriptingSubsystemWrapper attachSubsystem(String target) {
            return CCS.attachSubsystem(target);
        }

        public void setThrowExceptions(boolean throwExceptions) {
            CCS.setThrowExceptions(throwExceptions);
        }

        public boolean getThrowExceptions() {
            return CCS.getThrowExceptions();
        }

        public void addStatusBusListener(ScriptingStatusBusListener listener) {
            CCS.addStatusBusListener(listener);
        }

        public void addStatusBusListener(ScriptingStatusBusListener listener, ScriptingStatusBusMessageFilter filter) {
            CCS.addStatusBusListener(listener, filter);
        }

        public void removeStatusBusListener(ScriptingStatusBusListener listener) {
            CCS.removeStatusBusListener(listener);
        }

        public Future<ScriptingStatusBusMessage> startListeningForStatusBusMessage(ScriptingStatusBusMessageFilter filter, int timeout) {
            return CCS.startListeningForStatusBusMessage(filter, timeout);
        }
    }
}

