/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.demo.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.agent.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;

@ConsoleLookup(id="org.lsst.ccs.gconsole.agent.AgentChannelsFilter", name="Fixed channel set", path="Demo/Fixed", description="Channels filter that displays a fixed set of channels.")
public class FilterFixed
extends AbstractChannelsFilter {
    private final String name;
    private final List<String> agents;
    private final LinkedHashMap<String, String> d2o;
    private final HashMap<String, List<String>> o2d;

    public FilterFixed(String name, Map<String, String> displayToOriginPath) {
        this.name = name;
        this.d2o = new LinkedHashMap<String, String>(displayToOriginPath);
        this.o2d = new HashMap();
        this.d2o.forEach((display, origin) -> {
            List<String> paths = this.o2d.get(origin);
            if (paths == null) {
                paths = new ArrayList<String>();
                this.o2d.put((String)origin, paths);
            }
            paths.add((String)display);
        });
        this.o2d.entrySet().forEach(e -> {
            ArrayList paths = (ArrayList)e.getValue();
            if (paths.size() == 1) {
                e.setValue(Collections.singletonList(paths.get(0)));
            } else {
                paths.trimToSize();
            }
        });
        HashSet agentNames = new HashSet();
        this.o2d.keySet().forEach(origin -> {
            String[] ss = origin.split("/");
            agentNames.add(ss[0]);
        });
        this.agents = new ArrayList<String>(agentNames);
    }

    public static FilterFixed getInstance(int intParameter, String name, boolean boolParameter, AlertState enumParameter) {
        LinkedHashMap<String, String> in = new LinkedHashMap<String, String>();
        in.put("REB0//Global/Power/VP5_UNREG/Voltage", "monitor-test/REB0/Global/Power/VP5_UNREG/Voltage");
        in.put("REB0//Global/Power/VP5_UNREG/Current", "monitor-test/REB0/Global/Power/VP5_UNREG/Current");
        in.put("REB0//Global/Power/VP5_UNREG/Power", "monitor-test/REB0/Global/Power/VP5_UNREG/Power");
        in.put("REB0//Global/Power/VP7_UNREG/Voltage", "monitor-test/REB0/Global/Power/VP7_UNREG/Voltage");
        in.put("Voltages//Global/Power/VP5_UNREG", "monitor-test/REB0/Global/Power/VP5_UNREG/Voltage");
        in.put("Voltages//Global/Power/VP7_UNREG", "monitor-test/REB0/Global/Power/VP7_UNREG/Voltage");
        in.put("2 subs//From test", "monitor-test/REB0/Global/Power/VP5_UNREG/Voltage");
        in.put("2 subs//From demo", "demo-subsystem-with-monitoring/DemoChannel1");
        return new FilterFixed("Demo: Fixed Set", in);
    }

    public static String getPath() {
        return "static/getPath";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getAgents() {
        return this.agents;
    }

    @Override
    public List<String> getDisplayChannels() {
        return new ArrayList<String>(this.d2o.keySet());
    }

    @Override
    public String getOriginPath(String displayPath) {
        return this.d2o.get(displayPath);
    }

    @Override
    public List<String> getDisplayPath(String originPath) {
        List<String> out = this.o2d.get(originPath);
        return out == null ? Collections.emptyList() : out;
    }
}

