package org.lsst.ccs.subsystem.monitor.ui;

/**
 ******************************************************************************
 **
 **  Generic monitoring GUI.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class MonMainGui extends MonitorGui {

    public MonMainGui(String[] names) {
        super();
        MonMainAssembly pnl = new MonMainAssembly(this);
        pnl.setSubsystems(names);
        panel = pnl;
        for (int j = 0; j < names.length; j++) {
            addSubsys(names[j], j, "getFullState");
        }
    }

    public static void main(String[] args) throws Exception
    {
        if (args.length < 3) {
            throw new IllegalArgumentException("Need 3 arguments");
        }
        String[] names = new String[args.length - 2];
        System.arraycopy(args, 2, names, 0, names.length);
        (new MonMainGui(names)).startGui(args[0], args[1]);
    }

}
