package org.lsst.ccs.gconsole.plugins.demo.optpage;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.*;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;

/**
 * 
 *
 * @author onoprien
 */
//@Plugin(name = "Optional Page Demo Plugin",
//        id="opt-page-demo",
//        description = "Demo for adding optional pages.")
public class OptionalTestPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private final OptionalPage opt1 = new OptPage1();
    private final OptionalPage opt2 = new OptPage2();

// -- Life cycle : -------------------------------------------------------------
    
    @Override
    public void initialize() {
        
        AbstractAction act = new AbstractAction("Run Optional Page Demo 1") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Boolean)getValue(Action.SELECTED_KEY)) {
                    Console.getConsole().addOptionalPage(opt1);
                } else {
                    Console.getConsole().removeOptionalPage(opt1.getPath());
                }
            }
        };
        act.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(act, "Demo", "Optional Page");
        
        act = new AbstractAction("Run Optional Page Demo 2") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Boolean)getValue(Action.SELECTED_KEY)) {
                    Console.getConsole().addOptionalPage(opt2);
                } else {
                    Console.getConsole().removeOptionalPage(opt2.getPath());
                }
            }
        };
        act.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(act, "Demo", "Optional Page");

    }
    
// -- Optional page descriptors : ----------------------------------------------
    
    static class OptPage1 implements OptionalPage {

        @Override
        public String getPath() {
            return "Demo/OptPage1";
        }

        @Override
        public boolean isAutoOpen() {
            return true;
        }

        @Override
        public String getPage(AgentInfo agent) {
            System.out.println("Reurning page name for "+ agent.getName());
            return "";
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            System.out.println("Opening page for "+ agent.getName());
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            JLabel label = new JLabel(agent.getName());
            box.add(label);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        @Override
        public void close(String page) {
            System.out.println("Closing "+ page);
        }

        @Override
        public boolean agentDisconnected(AgentInfo agent) {
            System.out.println("Disconnection: "+ agent.getName());
            return false;
        }
        
    }
    
    static class OptPage2 implements OptionalPage {
        
        private final JLabel label = new JLabel();
        private final ArrayList<String> agents = new ArrayList<>();

        @Override
        public String getPath() {
            return "Demo/OptPage2";
        }

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            return agent.getName().equals("monitor-test") ? null : "Many agents";
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            if (existingComponent == null) {
                existingComponent = new JPanel(new BorderLayout());
                existingComponent.add(label);
            }
            agents.add(agent.getName());
            StringBuilder sb = new StringBuilder("<html>");
            agents.forEach(a -> sb.append(a).append("<p>"));
            label.setText(sb.toString());
            return existingComponent;
        }

        @Override
        public void close(String page) {
            agents.clear();
        }

        @Override
        public boolean agentDisconnected(AgentInfo agent) {
            agents.remove(agent.getName());
            StringBuilder sb = new StringBuilder("<html>");
            agents.forEach(a -> sb.append(a).append("<p>"));
            label.setText(sb.toString());
            return false;
        }
        
    }

}
