package org.lsst.ccs.gconsole.agent;

import java.util.HashMap;
import org.lsst.ccs.bus.data.AgentInfo;
import org.python.google.common.base.Objects;

/**
 * Mutable version of {@link AgentChannel}.
 *
 * @author onoprien
 */
public class MutableAgentChannel extends AgentChannel {

// -- Life cycle : -------------------------------------------------------------
    
    public MutableAgentChannel(String path, AgentInfo agent) {
        super(path, agent);
    }
    
    public MutableAgentChannel(AgentChannel other) {
        super(other);
    }
    
    
// -- Setters : ----------------------------------------------------------------
    
    /**
     * Sets the value of the specified attribute.
     * The attribute value does not change if the new value is equal to the old one.
     * 
     * @param key The attribute is identified by the string returned by {@code toString()} method of the key object.
     *            If {@code key} is {@code null} or evaluates to {@link VALUE_KEY}, the central value is set.
     * @param value The new value.
     * @return {@code true} if the attribute value has changed as a result of this call.
     */
    public synchronized boolean set(Object key, Object value) {
        if (key == null) return set(value);
        String sKey = key.toString();
        if (VALUE_KEY.equals(sKey)) return set(value);
        if (data == null) {
            if (value == null) {
                return false;
            } else {
                data = new HashMap<>(4);
                data.put(sKey, value);
                return true;
            }
        } else {
            if (value == null) {
                Object oldValue = data.remove(sKey);
                if (data.isEmpty()) data = null;
                return oldValue != null;
            } else {
                Object oldValue = data.put(sKey, value);
                return !value.equals(oldValue);
            }
        }
    }
    
    /**
     * Sets the value of this channel.
     * The value will not change if the new value is equal to the old one.
     * 
     * @param value New value.
     * @return {@code true} if the value has changed as a result of this call.
     */
    public synchronized boolean set(Object value) {
        boolean out = !Objects.equal(this.value, value);
        if (out) this.value = value;
        return out;
    }

}
